/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.oasis.client.animator;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.oasis.entity.tubunasusdurovela.TubunasusDurovelaEntity;
import java.util.List;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class TubunasusDurovelaAnimator
extends GeneralAnimator<TubunasusDurovelaEntity> {
    private float lastStableHeadCompensate = 0.0f;

    public TubunasusDurovelaAnimator(TubunasusDurovelaEntity entity) {
        super(entity);
    }

    @Override
    public void animate(GeoModel<TubunasusDurovelaEntity> model, AnimationState<TubunasusDurovelaEntity> animationState) {
        if (((TubunasusDurovelaEntity)this.entity).getDeadProgress() != 0) {
            return;
        }
        this.animTail(model);
        if (!((TubunasusDurovelaEntity)animationState.getAnimatable()).getAnimator().isInScreen) {
            this.animHead(model, animationState);
        }
    }

    protected void animHead(GeoModel<TubunasusDurovelaEntity> model, AnimationState<TubunasusDurovelaEntity> animationState) {
        if (((TubunasusDurovelaEntity)this.entity).m_6162_()) {
            return;
        }
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        String[] boneNames = new String[]{"neck2", "neck3"};
        List<GeoBone> bones = this.getBonesByName(boneNames, model);
        float netHeadYaw = (float)Math.toRadians(modelData.netHeadYaw());
        float headPitch = (float)Math.toRadians(modelData.headPitch());
        float[] amplifier = new float[]{0.5f, 0.6f};
        for (GeoBone bone : bones) {
            if (bone.getName().equals("neck2")) {
                float targetCompensation = (float)Math.toRadians(this.getModelPitch(animationState.getPartialTick()));
                if (((TubunasusDurovelaEntity)this.entity).getStableHead()) {
                    bone.setRotX(bone.getRotX() - targetCompensation);
                    this.lastStableHeadCompensate = targetCompensation;
                } else {
                    float currentCompensation = Mth.m_14121_((float)this.lastStableHeadCompensate, (float)0.0f, (float)0.01f);
                    bone.setRotX(bone.getRotX() - currentCompensation);
                    this.lastStableHeadCompensate = currentCompensation;
                }
            }
            bone.setRotY(netHeadYaw * amplifier[bones.indexOf(bone)]);
            bone.setRotX(headPitch * 0.5f);
        }
    }

    protected void animTail(GeoModel<TubunasusDurovelaEntity> model) {
        String[] tailBoneNames = new String[]{"tail", "tail2", "tail3", "tail4"};
        List<GeoBone> tailBones = this.getBonesByName(tailBoneNames, model);
        for (int i = 0; i < tailBones.size(); ++i) {
            GeoBone tail = tailBones.get(i);
            float reversedIndex = tailBones.size() - i;
            float logFactor = (float)(Math.log(reversedIndex + 1.0f) / Math.log(tailBones.size() + 1));
            float angleLimit = 50.0f * logFactor;
            float yawOfs = Mth.m_14036_((float)(this.yawTrail.get(this.partialTicks, 0, i + 1) * 0.5f), (float)(-angleLimit), (float)angleLimit);
            tail.setRotY((float)Math.toRadians(yawOfs));
        }
    }
}

