/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.oasis.entity.pygopodusannulatum;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.entity.ErsTamable;
import cn.aurorian.ers.entity.GeneralBodyControl;
import cn.aurorian.ers.entity.ai.goal.MobAvodingEntityGoal;
import cn.aurorian.ers.entity.ai.movecontrol.LimitedMoveControl;
import cn.aurorian.ers.entity.ai.navigation.MMGroundPathNavigation;
import cn.aurorian.ers.util.ErsUtils;
import cn.aurorian.ers.util.SimpleAutoPlayingSoundKeyFrameHandler;
import cn.aurorian.oasis.client.animator.PygopodusAnnulatumAnimator;
import cn.aurorian.oasis.entity.pygopodusannulatum.ai.AnnulatumEatGoal;
import cn.aurorian.oasis.init.OasisEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PygopodusAnnulatumEntity
extends ErsTamable<PygopodusAnnulatumEntity> {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final GeneralAnimator<PygopodusAnnulatumEntity> animator;
    public static final EntityDataAccessor<Integer> NEXT_CHANGE_TIME = SynchedEntityData.m_135353_(PygopodusAnnulatumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> EATING = SynchedEntityData.m_135353_(PygopodusAnnulatumEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public PygopodusAnnulatumEntity(EntityType<? extends ErsTamable> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21342_ = new LimitedMoveControl((Mob)this);
        this.animator = new PygopodusAnnulatumAnimator(this);
        this.doHunger = true;
    }

    public void setEating(boolean eating) {
        this.f_19804_.m_135381_(EATING, (Object)eating);
    }

    public boolean isEating() {
        return (Boolean)this.f_19804_.m_135370_(EATING);
    }

    @Override
    public GeneralAnimator<PygopodusAnnulatumEntity> getAnimator() {
        return this.animator;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new MMGroundPathNavigation((Mob)this, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + this.f_19796_.m_216332_(100, 300)));
        this.f_19804_.m_135372_(EATING, (Object)false);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new GeneralBodyControl((Mob)this, 10);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            this.animator.tick();
            if (!this.m_6162_() && this.f_19797_ > (Integer)this.f_19804_.m_135370_(NEXT_CHANGE_TIME)) {
                this.f_19804_.m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(200, 400)));
                int newState = RandomSource.m_216327_().m_188503_(3);
                if (newState != 0 && !ErsUtils.isMoving((Mob)this) && !this.m_20069_()) {
                    if (newState == 1) {
                        this.triggerAnim("extra", "idle2");
                    } else {
                        this.triggerAnim("extra", "idle3");
                    }
                }
            }
        } else {
            float hunger = this.getHunger();
            if (this.f_19797_ % 200 == 0) {
                this.setHunger(hunger - 0.1f);
            }
            if (hunger > 90.0f && this.m_146764_() == 0 && this.m_5957_() && !this.m_6162_()) {
                this.m_27595_(null);
            }
        }
        if (ErsUtils.isMoving((Mob)this)) {
            this.updateMount();
        }
    }

    public void updateMount() {
        this.m_20088_().m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(100, 300)));
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle2");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle3");
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.isMoving() && !this.m_6162_() && this.m_9236_().f_46441_.m_188501_() < 0.25f) {
            Entity entity = pSource.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (ErsUtils.calculateFallDirection(livingEntity, (LivingEntity)this)) {
                    this.triggerAnim("extra", "dodge_right");
                } else {
                    this.triggerAnim("extra", "dodge_left");
                }
            }
            return false;
        }
        this.setHunger(Math.min(89.9f, this.getHunger()));
        return super.m_6469_(pSource, pAmount);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, new MobAvodingEntityGoal<Player>((PathfinderMob)this, Player.class, 8.0f, 1.0, 1.8));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0){

            public void m_8056_() {
                super.m_8056_();
                this.f_25684_.m_6858_(true);
            }

            public void m_8041_() {
                super.m_8041_();
                this.f_25684_.m_6858_(false);
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new AnnulatumEatGoal(this));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 10, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.m_20069_() && !this.m_20096_()) {
                if (this.m_20142_() || ErsUtils.isMoving((Mob)this)) {
                    builder.thenLoop("animation.swim");
                } else {
                    builder.thenLoop("animation.swim_idle");
                }
            } else if (this.m_20142_()) {
                builder.thenLoop("animation.run");
            } else if (state.isMoving() || ErsUtils.isMoving((Mob)this)) {
                if (this.isEating()) {
                    builder.thenLoop("animation.walk2");
                } else if (this.m_6162_()) {
                    builder.thenLoop("animation.run");
                } else {
                    builder.thenLoop("animation.walk");
                }
            } else {
                builder.thenLoop("animation.idle");
            }
            return state.setAndContinue(builder);
        }).setSoundKeyframeHandler(new SimpleAutoPlayingSoundKeyFrameHandler("oasis"));
        AnimationController extra = new AnimationController((GeoAnimatable)this, "extra", 2, state -> PlayState.STOP).triggerableAnim("idle2", RawAnimation.begin().thenPlay("animation.idle2")).triggerableAnim("idle3", RawAnimation.begin().thenPlay("animation.idle3")).triggerableAnim("dodge_left", RawAnimation.begin().thenPlay("animation.dodge_left")).triggerableAnim("dodge_right", RawAnimation.begin().thenPlay("animation.dodge_right")).setSoundKeyframeHandler(new SimpleAutoPlayingSoundKeyFrameHandler("oasis"));
        controllerRegistrar.add(new AnimationController[]{main, extra});
    }

    public void m_27563_(@NotNull ServerLevel pLevel, @NotNull Animal pMate) {
        super.m_27563_(pLevel, pMate);
        this.setHunger(this.getHunger() - 10.0f);
    }

    @Override
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ErsTamable<?> getBreedOffspring(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return (ErsTamable)((EntityType)OasisEntities.PYGOPODUS_ANNULATUM.get()).m_20615_((Level)level);
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new AgeableMob.AgeableMobGroupData(0.2f);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }
}

