/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers;

import cn.aurorian.ers.block.SwampDragonArtificialNestBlock;
import cn.aurorian.ers.block.be.SwampDragonArtificialNestBlockEntity;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisEntity;
import cn.aurorian.oasis.entity.pygopodusannulatum.PygopodusAnnulatumEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin(value="ers")
public class ErsJadePlugin
implements IWailaPlugin {
    public static final ResourceLocation AGE = ResourceLocation.fromNamespaceAndPath((String)"ers", (String)"age");
    public static final ResourceLocation FOOD = ResourceLocation.fromNamespaceAndPath((String)"ers", (String)"food");
    public static final ResourceLocation HATCH = ResourceLocation.fromNamespaceAndPath((String)"ers", (String)"hatch");

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerEntityComponent((IEntityComponentProvider)AgeProvider.INSTANCE, DentisaurusLongirostrisEntity.class);
        registration.registerEntityComponent((IEntityComponentProvider)LongirostrisFoodProvider.INSTANCE, DentisaurusLongirostrisEntity.class);
        registration.registerEntityComponent((IEntityComponentProvider)AnnulatumFoodProvider.INSTANCE, PygopodusAnnulatumEntity.class);
        registration.registerBlockComponent((IBlockComponentProvider)HatchProvider.INSTANCE, SwampDragonArtificialNestBlock.class);
        registration.addConfig(AGE, true);
        registration.addConfig(FOOD, true);
        registration.addConfig(HATCH, true);
    }

    private static enum AgeProvider implements IEntityComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            if (!config.get(AGE)) {
                return;
            }
            Entity entity = accessor.getEntity();
            if (entity instanceof DentisaurusLongirostrisEntity) {
                DentisaurusLongirostrisEntity sotek = (DentisaurusLongirostrisEntity)entity;
                int ageInDays = sotek.getAgeInDays();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.age", (Object[])new Object[]{ageInDays}));
            }
        }

        public ResourceLocation getUid() {
            return AGE;
        }
    }

    private static enum LongirostrisFoodProvider implements IEntityComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            if (!config.get(FOOD)) {
                return;
            }
            Entity entity = accessor.getEntity();
            if (entity instanceof DentisaurusLongirostrisEntity) {
                DentisaurusLongirostrisEntity entity2 = (DentisaurusLongirostrisEntity)entity;
                float hunger = entity2.getHunger();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.food", (Object[])new Object[]{Float.valueOf(hunger)}));
            }
        }

        public ResourceLocation getUid() {
            return FOOD;
        }
    }

    private static enum AnnulatumFoodProvider implements IEntityComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            if (!config.get(FOOD)) {
                return;
            }
            Entity entity = accessor.getEntity();
            if (entity instanceof PygopodusAnnulatumEntity) {
                PygopodusAnnulatumEntity entity2 = (PygopodusAnnulatumEntity)entity;
                float hunger = entity2.getHunger();
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.food", (Object[])new Object[]{Float.valueOf(hunger)}));
            }
        }

        public ResourceLocation getUid() {
            return FOOD;
        }
    }

    private static enum HatchProvider implements IBlockComponentProvider
    {
        INSTANCE;


        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            if (!config.get(FOOD)) {
                return;
            }
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof SwampDragonArtificialNestBlockEntity) {
                SwampDragonArtificialNestBlockEntity entity = (SwampDragonArtificialNestBlockEntity)blockEntity;
                if (!entity.hasEgg()) {
                    return;
                }
                int timer = entity.getHatchingTime() / 480;
                tooltip.add((Component)Component.m_237110_((String)"tooltip.ers.hatch", (Object[])new Object[]{"\u00a7a" + timer}));
            }
        }

        public ResourceLocation getUid() {
            return HATCH;
        }
    }
}

