/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.client.animator;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisEntity;
import java.util.List;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class SwampDragonAnimator
extends GeneralAnimator<DentisaurusLongirostrisEntity> {
    private float lastStableHeadCompensate = 0.0f;

    public SwampDragonAnimator(DentisaurusLongirostrisEntity entity) {
        super(entity);
    }

    @Override
    public void animate(GeoModel<DentisaurusLongirostrisEntity> model, AnimationState<DentisaurusLongirostrisEntity> animationState) {
        this.animTail(model, animationState);
        if (!((DentisaurusLongirostrisEntity)animationState.getAnimatable()).isInScreen()) {
            this.animHead(model, animationState);
        }
    }

    protected void animTail(GeoModel<DentisaurusLongirostrisEntity> model, AnimationState<DentisaurusLongirostrisEntity> animationState) {
        String[] tailBoneNames = ((DentisaurusLongirostrisEntity)this.entity).isMature() ? new String[]{"Tail_A", "Tail_B", "Tail_C", "Tail_D", "Tail_E", "Tail_F", "Tail_G", "Tail_H", "Tail_I", "Tail_J", "Tail_K", "Tail_L", "Tail_M"} : new String[]{"Tail", "Tail_2", "Tail_3", "Tail_4", "Tail_5", "Tail_6", "Tail_7", "Tail_8", "Tail_9", "Tail_10", "Tail_11"};
        List<GeoBone> tailBones = this.getBonesByName(tailBoneNames, model);
        for (int i = 0; i < tailBones.size(); ++i) {
            GeoBone tail = tailBones.get(i);
            float reversedIndex = tailBones.size() - i;
            float logFactor = (float)(Math.log(reversedIndex + 1.0f) / Math.log(tailBones.size() + 1));
            float angleLimit = 160.0f * logFactor;
            float pitchOfs = Mth.m_14036_((float)(this.pitchTrail.get(this.partialTicks, 0, i + 1) * 0.13f), (float)(-angleLimit), (float)angleLimit);
            float yawOfs = Mth.m_14036_((float)(this.yawTrail.get(this.partialTicks, 0, i + 1) * 0.13f), (float)(-angleLimit), (float)angleLimit);
            if (i >= 5 && i <= 7 && !((DentisaurusLongirostrisEntity)this.entity).m_20142_()) {
                pitchOfs *= 3.5f;
                yawOfs *= 3.5f;
            }
            if (i < 3) {
                float extraRotationFactor = 5.5f - (float)i * 0.3f;
                pitchOfs *= extraRotationFactor;
                yawOfs *= extraRotationFactor;
                if (((DentisaurusLongirostrisEntity)this.entity).m_20142_()) {
                    yawOfs *= 0.8f;
                }
            }
            tail.setRotX((float)((double)tail.getRotX() + Math.toRadians(pitchOfs)));
            tail.setRotY((float)((double)tail.getRotY() + Math.toRadians(yawOfs)));
        }
    }

    protected void animHead(GeoModel<DentisaurusLongirostrisEntity> model, AnimationState<DentisaurusLongirostrisEntity> animationState) {
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        String[] boneNames = ((DentisaurusLongirostrisEntity)this.entity).isMature() ? new String[]{"Neck_A", "Neck_B", "Neck_C", "Neck_D", "Neck_E", "Head"} : new String[]{"Neck", "Neck_2", "Neck_3", "Neck_4", "Neck_5", "Head"};
        List<GeoBone> bones = this.getBonesByName(boneNames, model);
        float netHeadYaw = (float)Math.toRadians(modelData.netHeadYaw());
        float headPitch = (float)Math.toRadians(modelData.headPitch());
        float[] yawFactors = new float[]{0.15f, 0.15f, 0.15f, 0.2f, 0.25f, 0.15f};
        for (int i = 0; i < bones.size(); ++i) {
            if (bones.get(i).getName().equals("Neck_A") || bones.get(i).getName().equals("Neck")) {
                float targetCompensation = (float)Math.toRadians(this.getModelPitch(animationState.getPartialTick()));
                if (((DentisaurusLongirostrisEntity)this.entity).getStableHead()) {
                    bones.get(i).setRotX(bones.get(i).getRotX() - targetCompensation);
                    this.lastStableHeadCompensate = targetCompensation;
                } else {
                    float currentCompensation = Mth.m_14121_((float)this.lastStableHeadCompensate, (float)0.0f, (float)0.01f);
                    bones.get(i).setRotX(bones.get(i).getRotX() - currentCompensation);
                    this.lastStableHeadCompensate = currentCompensation;
                }
            }
            bones.get(i).setRotY(bones.get(i).getRotY() + netHeadYaw * yawFactors[i]);
            bones.get(i).setRotX(bones.get(i).getRotX() + headPitch * yawFactors[i]);
        }
    }
}

