/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.client.animator;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.entity.creatures.terridensaurussaevus.TerridensaurusSaevusEntity;
import java.util.List;
import net.minecraft.util.Mth;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class TerridensaurusSaevusAnimator
extends GeneralAnimator<TerridensaurusSaevusEntity> {
    private float lastStableHeadCompensate = 0.0f;

    public TerridensaurusSaevusAnimator(TerridensaurusSaevusEntity entity) {
        super(entity);
    }

    @Override
    public void animate(GeoModel<TerridensaurusSaevusEntity> model, AnimationState<TerridensaurusSaevusEntity> animationState) {
        this.animTail(model);
        if (!((TerridensaurusSaevusEntity)animationState.getAnimatable()).isInScreen()) {
            this.animHead(model, animationState);
        }
    }

    protected void animTail(GeoModel<TerridensaurusSaevusEntity> model) {
        String[] tailBoneNames = new String[]{"tail", "tail2", "tail3", "tail4", "tail5"};
        List<GeoBone> tailBones = this.getBonesByName(tailBoneNames, model);
        for (int i = 0; i < tailBones.size(); ++i) {
            GeoBone tail = tailBones.get(i);
            float reversedIndex = tailBones.size() - i;
            float logFactor = (float)(Math.log(reversedIndex + 1.0f) / Math.log(tailBones.size() + 1));
            float angleLimit = 160.0f * logFactor;
            float pitchOfs = Mth.m_14036_((float)(this.pitchTrail.get(this.partialTicks, 0, i + 1) * 0.13f), (float)(-angleLimit), (float)angleLimit);
            float yawOfs = Mth.m_14036_((float)(this.yawTrail.get(this.partialTicks, 0, i + 1) * 0.13f), (float)(-angleLimit), (float)angleLimit);
            float extraRotationFactor = 4.5f - (float)i * 0.3f;
            if (i >= 4 && !((TerridensaurusSaevusEntity)this.entity).m_20142_()) {
                pitchOfs *= 1.2f;
                yawOfs *= 1.2f;
            }
            pitchOfs *= extraRotationFactor;
            yawOfs *= extraRotationFactor;
            if (((TerridensaurusSaevusEntity)this.entity).m_20142_()) {
                yawOfs *= 0.8f;
            }
            tail.setRotX((float)((double)tail.getRotX() + Math.toRadians(pitchOfs)));
            tail.setRotY((float)((double)tail.getRotY() + Math.toRadians(yawOfs)));
        }
    }

    protected void animHead(GeoModel<TerridensaurusSaevusEntity> model, AnimationState<TerridensaurusSaevusEntity> animationState) {
        EntityModelData modelData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        String[] boneNames = new String[]{"neck", "neck2", "neck3"};
        List<GeoBone> bones = this.getBonesByName(boneNames, model);
        float netHeadYaw = (float)Math.toRadians(modelData.netHeadYaw());
        float headPitch = (float)Math.toRadians(modelData.headPitch());
        if (((TerridensaurusSaevusEntity)animationState.getAnimatable()).getAttackState().getType().isTurning()) {
            netHeadYaw = Mth.m_14121_((float)netHeadYaw, (float)0.0f, (float)(Math.abs(netHeadYaw) * 0.2f));
            headPitch = Mth.m_14121_((float)headPitch, (float)0.0f, (float)(Math.abs(headPitch) * 0.2f));
        }
        float[] yawFactors = new float[]{0.25f, 0.35f, 0.35f};
        for (int i = 0; i < bones.size(); ++i) {
            if (bones.get(i).getName().equals("neck")) {
                float targetCompensation = (float)Math.toRadians(this.getModelPitch(animationState.getPartialTick()));
                if (((TerridensaurusSaevusEntity)this.entity).getStableHead()) {
                    bones.get(i).setRotX(bones.get(i).getRotX() - targetCompensation);
                    this.lastStableHeadCompensate = targetCompensation;
                } else {
                    float currentCompensation = Mth.m_14121_((float)this.lastStableHeadCompensate, (float)0.0f, (float)0.01f);
                    bones.get(i).setRotX(bones.get(i).getRotX() - currentCompensation);
                    this.lastStableHeadCompensate = currentCompensation;
                }
            }
            if (((TerridensaurusSaevusEntity)animationState.getAnimatable()).getAttackState().getType().isTurning()) {
                int n = i;
                yawFactors[n] = yawFactors[n] * Math.max(0.0f, 1.0f - (float)(((TerridensaurusSaevusEntity)animationState.getAnimatable()).getAttackState().getType().getAnimationLength() - ((TerridensaurusSaevusEntity)animationState.getAnimatable()).getAttackState().animatorTick) * 0.025f);
            }
            bones.get(i).setRotY(bones.get(i).getRotY() + netHeadYaw * yawFactors[i]);
            bones.get(i).setRotZ(bones.get(i).getRotZ() + netHeadYaw * yawFactors[i] * -0.6f);
            bones.get(i).setRotX(bones.get(i).getRotX() + headPitch * yawFactors[i]);
        }
    }
}

