/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.client.gui;

import cn.aurorian.ers.EcologicalReplenishmentStation;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;

public class VehicleStaminaRenderer {
    static Minecraft minecraft = Minecraft.m_91087_();
    public static ResourceLocation STAMINA = EcologicalReplenishmentStation.prefix("textures/gui/stamina.png");
    protected static final RandomSource random = RandomSource.m_216327_();
    public static IGuiOverlay STAMINA_OVERLAY = (forgeGui, guiGraphics, partialTicks, screenWidth, screenHeight) -> VehicleStaminaRenderer.render(forgeGui, guiGraphics, screenWidth, screenHeight, (Player)VehicleStaminaRenderer.minecraft.f_91074_);

    public static void render(ForgeGui gui, GuiGraphics guiGraphics, int width, int height, Player player) {
        Entity entity;
        if (gui.shouldDrawSurvivalElements() && (entity = player.m_20202_()) instanceof ErsTamableVehicle) {
            ErsTamableVehicle vehicle = (ErsTamableVehicle)entity;
            minecraft.m_91307_().m_6180_("stamina");
            RenderSystem.enableBlend();
            int left = width / 2 + 91;
            int top = height - gui.rightHeight;
            gui.rightHeight += 10;
            float level = vehicle.getStamina() / 5.0f;
            for (int i = 0; i < 10; ++i) {
                int idx = i * 2 + 1;
                int x = left - i * 8 - 9;
                int y = top;
                if (level <= 50.0f && (float)gui.m_93079_() % (level * 3.0f + 1.0f) == 0.0f) {
                    y = top + (random.m_188503_(3) - 1);
                }
                guiGraphics.m_280163_(STAMINA, x, y, 0.0f, 0.0f, 9, 9, 25, 9);
                if ((float)idx < level) {
                    guiGraphics.m_280163_(STAMINA, x, y, 16.0f, 0.0f, 9, 9, 25, 9);
                    continue;
                }
                if ((float)idx != level) continue;
                guiGraphics.m_280163_(STAMINA, x, y, 8.0f, 0.0f, 9, 9, 25, 9);
            }
            RenderSystem.disableBlend();
            minecraft.m_91307_().m_7238_();
        }
    }

    public static void registerStaminaOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.MOUNT_HEALTH.id(), "stamina", STAMINA_OVERLAY);
    }
}

