/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.client.model.entity;

import cn.aurorian.ers.EcologicalReplenishmentStation;
import cn.aurorian.ers.client.model.entity.ErsModel;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.molang.MolangParser;

public class SwampDragonModel
extends ErsModel<DentisaurusLongirostrisEntity> {
    private static final Map<Integer, Integer> angleCache = new HashMap<Integer, Integer>();

    @Override
    public ResourceLocation getModelResource(DentisaurusLongirostrisEntity entity) {
        if (!entity.isMature()) {
            return EcologicalReplenishmentStation.prefix("geo/entity/dentisaurus_longirostris_baby.geo.json");
        }
        if (entity.isElite()) {
            return EcologicalReplenishmentStation.prefix("geo/entity/dentisaurus_longirostris_elite.geo.json");
        }
        return super.getModelResource(entity);
    }

    @Override
    public ResourceLocation getTextureResource(DentisaurusLongirostrisEntity animatable) {
        Object base = "textures/entity/dentisaurus_longirostris";
        if (animatable.isElite()) {
            base = (String)base + "_elite";
            if (animatable.m_8077_()) {
                if (animatable.m_7770_().getString().equals("Ladon")) {
                    return EcologicalReplenishmentStation.prefix((String)base + "_ladon.png");
                }
                if (animatable.m_7770_().getString().equals("Forsaken")) {
                    return EcologicalReplenishmentStation.prefix((String)base + "_forsaken.png");
                }
                if (animatable.m_7770_().getString().equals("Acheron_Pollux")) {
                    return EcologicalReplenishmentStation.prefix((String)base + "_acheron_pollux.png");
                }
            }
        } else if (!animatable.isMature()) {
            base = (String)base + "_baby";
        } else if (animatable.m_8077_() && animatable.m_7770_().getString().equals("profound")) {
            return EcologicalReplenishmentStation.prefix((String)base + "_profound.png");
        }
        switch (animatable.getVariant().getId()) {
            case 3: 
            case 4: 
            case 5: {
                base = (String)base + "_lackyellow";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                base = (String)base + "_black";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                base = (String)base + "_white";
                break;
            }
        }
        if (animatable.isMature()) {
            switch (animatable.getVariant().getId()) {
                case 0: 
                case 3: 
                case 6: 
                case 9: {
                    base = (String)base + ".png";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 10: {
                    base = (String)base + "_light.png";
                    break;
                }
                case 2: 
                case 5: 
                case 8: 
                case 11: {
                    base = (String)base + "_deep.png";
                }
            }
        } else {
            base = (String)base + ".png";
        }
        return EcologicalReplenishmentStation.prefix((String)base);
    }

    @Override
    public ResourceLocation getAnimationResource(DentisaurusLongirostrisEntity entity) {
        if (!entity.isMature()) {
            return EcologicalReplenishmentStation.prefix("animations/entity/dentisaurus_longirostris_baby.animation.json");
        }
        return super.getAnimationResource(entity);
    }

    public void applyMolangQueries(DentisaurusLongirostrisEntity animatable, double animTime) {
        super.applyMolangQueries((GeoAnimatable)animatable, animTime);
        MolangParser parser = MolangParser.INSTANCE;
        angleCache.putIfAbsent(animatable.m_19879_(), 0);
        if (animatable.m_20160_()) {
            parser.setMemoizedValue("v.move_turn", () -> angleCache.get(animatable.m_19879_()).intValue());
        }
        Integer angle = angleCache.get(animatable.m_19879_());
        if (animatable.getRotDirection().isNone()) {
            parser.setMemoizedValue("v.turn", () -> 0.0);
            parser.setMemoizedValue("v.w_turn", () -> 0.0);
            if (angle > 0) {
                Integer n = angle;
                angle = angle - 1;
            } else if (angle < 0) {
                Integer n = angle;
                angle = angle + 1;
            }
        } else if (animatable.getRotDirection().isRight()) {
            if (animatable.isMature()) {
                parser.setMemoizedValue("v.turn", () -> -40.0);
            } else {
                parser.setMemoizedValue("v.turn", () -> 40.0);
            }
            parser.setMemoizedValue("v.w_turn", () -> -100.0);
            angle = angle - 1;
            angle = Math.max(-30, angle);
        } else if (animatable.getRotDirection().isLeft()) {
            if (animatable.isMature()) {
                parser.setMemoizedValue("v.turn", () -> 40.0);
            } else {
                parser.setMemoizedValue("v.turn", () -> -40.0);
            }
            parser.setMemoizedValue("v.w_turn", () -> 100.0);
            angle = angle + 1;
            angle = Math.min(30, angle);
        }
        angleCache.put(animatable.m_19879_(), angle);
    }
}

