/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.data;

import cn.aurorian.ers.EcologicalReplenishmentStation;
import cn.aurorian.ers.init.ErsEntities;
import cn.aurorian.ers.init.ErsItems;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnterBlockTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.TameAnimalTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import org.jetbrains.annotations.NotNull;

public class ErsAdvancementProvider
extends ForgeAdvancementProvider {
    private static final ResourceLocation BACKGROUND_LOCATION = EcologicalReplenishmentStation.prefix("textures/block/soul_cube_side.png");

    public ErsAdvancementProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new ErsAdvancements()));
    }

    private static Advancement.Builder createAdvancement(String name, Advancement parent, ItemLike icon, ResourceLocation backGround, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(icon, (Component)Component.m_237115_((String)("advancements.ers." + name + ".title")), (Component)Component.m_237115_((String)("advancements.ers." + name + ".desc")), backGround, frame, showToast, announceToChat, hidden);
    }

    private static Advancement.Builder createAdvancement(String name, Advancement parent, ItemLike icon, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
        return ErsAdvancementProvider.createAdvancement(name, parent, icon, null, frame, showToast, announceToChat, hidden);
    }

    private static class ErsAdvancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        private ErsAdvancements() {
        }

        public void generate(// Could not load outer class - annotation placement on inner may be incorrect
         @NotNull HolderLookup.Provider provider, @NotNull Consumer<Advancement> consumer, @NotNull ExistingFileHelper existingFileHelper) {
            Advancement enterWorld = ErsAdvancementProvider.createAdvancement("enter_world", null, (ItemLike)ErsItems.SOUL_CUBE.get(), BACKGROUND_LOCATION, FrameType.TASK, true, true, false).m_138386_("entered_world", (CriterionTriggerInstance)EnterBlockTrigger.TriggerInstance.m_31297_((Block)Blocks.f_50016_)).m_138389_(consumer, "ers:enter_world");
            Advancement swamp_dragon_egg = ErsAdvancementProvider.createAdvancement("swamp_dragon_egg", enterWorld, (ItemLike)ErsItems.SWAMP_DRAGON_EGG.get(), FrameType.TASK, true, true, true).m_138386_("has_swamp_dragon_egg", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ErsItems.SWAMP_DRAGON_EGG.get()})).m_138389_(consumer, "ers:swamp_dragon_egg");
            ErsAdvancementProvider.createAdvancement("tame_swamp_dragon", swamp_dragon_egg, (ItemLike)ErsItems.SWAMP_DRAGON_SADDLE.get(), FrameType.TASK, true, true, true).m_138386_("tamed_swamp_dragon", (CriterionTriggerInstance)TameAnimalTrigger.TriggerInstance.m_68848_((EntityPredicate)EntityPredicate.Builder.m_36633_().m_36636_((EntityType)ErsEntities.DENTISAURUS_LONGIROSTRIS.get()).m_36662_())).m_138389_(consumer, "ers:tame_swamp_dragon");
        }
    }
}

