/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.effect;

import cn.aurorian.ers.init.ErsDamageSource;
import cn.aurorian.ers.init.ErsMobEffects;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ErsBleedingEffect
extends MobEffect {
    private static final Map<LivingEntity, Vec3> previousPositions = new HashMap<LivingEntity, Vec3>();
    private static final Map<LivingEntity, Boolean> still = new HashMap<LivingEntity, Boolean>();

    public ErsBleedingEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public void m_6742_(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity.m_6336_().equals(MobType.f_21641_)) {
            pLivingEntity.m_21195_((MobEffect)this);
            return;
        }
        Vec3 currentPosition = new Vec3(pLivingEntity.m_20182_().m_7096_(), pLivingEntity.m_20182_().m_7098_(), pLivingEntity.m_20182_().m_7094_());
        Vec3 previousPosition = previousPositions.get(pLivingEntity);
        if (still.get(pLivingEntity) != null && still.get(pLivingEntity).booleanValue()) {
            still.put(pLivingEntity, false);
            MobEffectInstance instance = pLivingEntity.m_21124_((MobEffect)this);
            int amp = instance.m_19564_();
            pLivingEntity.m_21195_((MobEffect)this);
            if (amp != 0) {
                pLivingEntity.m_7292_(new MobEffectInstance((MobEffect)this, instance.m_19557_(), amp - 1, false, false, true));
            }
        }
        float modifier = 1.0f;
        if (!previousPositions.isEmpty() && previousPosition != null && previousPosition.equals((Object)currentPosition)) {
            modifier = 0.5f;
            still.put(pLivingEntity, true);
        } else {
            if (pLivingEntity.m_20142_()) {
                modifier = 2.0f;
            }
            still.put(pLivingEntity, false);
        }
        pLivingEntity.m_6469_(ErsDamageSource.getDamageSource(pLivingEntity.m_9236_(), ErsDamageSource.DIE_OF_BLEED), pLivingEntity.m_21233_() * 0.01f * (float)(pAmplifier + 1) * modifier);
        previousPositions.clear();
        previousPositions.put(pLivingEntity, currentPosition);
    }

    public void m_6386_(@NotNull LivingEntity pLivingEntity, @NotNull AttributeMap pAttributeMap, int pAmplifier) {
        super.m_6386_(pLivingEntity, pAttributeMap, pAmplifier);
        previousPositions.clear();
    }

    public boolean m_6584_(int pDuration, int pAmplifier) {
        return pDuration > 0 && pDuration % 120 == 0;
    }

    public static void giveBleedingEffect(LivingEntity target, int maxAmp) {
        ErsBleedingEffect.giveBleedingEffect(target, 1, maxAmp);
    }

    public static void giveBleedingEffect(LivingEntity target, int step, int maxAmp) {
        if (target.m_9236_().f_46443_) {
            return;
        }
        if (target.m_21224_() || target.m_6336_().equals(MobType.f_21641_)) {
            return;
        }
        MobEffectInstance instance = target.m_21124_((MobEffect)ErsMobEffects.BLEEDING.get());
        if (instance == null) {
            target.m_7292_(new MobEffectInstance((MobEffect)ErsMobEffects.BLEEDING.get(), 1200, 0, false, false, true));
        } else {
            int currentAmp = instance.m_19564_();
            if (currentAmp + step < maxAmp) {
                instance.m_19558_(new MobEffectInstance((MobEffect)ErsMobEffects.BLEEDING.get(), 1200, currentAmp + step, false, false, true));
                previousPositions.clear();
            } else {
                instance.m_19558_(new MobEffectInstance((MobEffect)ErsMobEffects.BLEEDING.get(), 1200, maxAmp, false, false, true));
                previousPositions.clear();
            }
        }
    }

    public static void removeBleedingEffect(LivingEntity target) {
        if (target == null || target.m_21224_()) {
            return;
        }
        MobEffectInstance instance = target.m_21124_((MobEffect)ErsMobEffects.BLEEDING.get());
        if (instance == null) {
            return;
        }
        int currentAmp = instance.m_19564_();
        target.m_21195_((MobEffect)ErsMobEffects.BLEEDING.get());
        int duration = instance.m_19557_();
        if (currentAmp > 0) {
            target.m_7292_(new MobEffectInstance((MobEffect)ErsMobEffects.BLEEDING.get(), duration, currentAmp - 1, false, false, true));
        }
    }
}

