/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity;

import cn.aurorian.ers.entity.AttackExecutor;
import cn.aurorian.ers.entity.AttackStrategy;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.entity.MobAttack;

public enum AttackType {
    EMPTY("empty", 0, AttackStrategy.EMPTY_STRATEGY, true),
    SWAMP_DRAGON_ATTACK("attack", 20, AttackStrategy.SWAMP_DRAGON_ATTACK_STRATEGY, true),
    SWAMP_DRAGON_ATTACK_WALK("attack-walk", 20, AttackStrategy.SWAMP_DRAGON_ATTACK_STRATEGY, true),
    SWAMP_DRAGON_ATTACK_RUN("attack-run", 20, AttackStrategy.SWAMP_DRAGON_ATTACK_STRATEGY, true),
    SWAMP_DRAGON_ATTACK_QUICK_SWIMMING("attack_quickly_swimming", 20, AttackStrategy.SWAMP_DRAGON_ATTACK_STRATEGY, true),
    SWAMP_DRAGON_ATTACK_SWIM_SHALLOW("attack_swim_shallow", 20, AttackStrategy.SWAMP_DRAGON_ATTACK_STRATEGY, true),
    SWAMP_DRAGON_ATTACK_SWIM_MID("attack_swim_mid", 20, AttackStrategy.SWAMP_DRAGON_ATTACK_STRATEGY, true),
    SWAMP_DRAGON_JUDGEMENT("attack2", 75, AttackStrategy.SWAMP_DRAGON_JUDGEMENT_STRATEGY, 10),
    SWAMP_DRAGON_SPECIAL_ATTACK("attack3", 85, AttackStrategy.SWAMP_DRAGON_SPECIAL_ATTACK_STRATEGY),
    SWAMP_DRAGON_ATTACK_TURN("attack_turn", 35, AttackStrategy.SWAMP_DRAGON_TURNING_ATTACK_STRATEGY, false, 5, true),
    SWAMP_DRAGON_ATTACK_SWIM_TURN("attack_swim_turn", 30, AttackStrategy.SWAMP_DRAGON_TURNING_ATTACK_STRATEGY, false, 5, true),
    SWAMP_DRAGON_SWIM_JUDGEMENT("swim_attack-placeholder", 80, AttackStrategy.SWAMP_DRAGON_JUDGEMENT_STRATEGY),
    SWAMP_DRAGON_SWIM_SPECIAL_ATTACK("swim_attack2", 85, AttackStrategy.SWAMP_DRAGON_SPECIAL_ATTACK_STRATEGY),
    SWAMP_DRAGON_CATCH_FISH_SMALL("catch_fish-small", 600, AttackStrategy.SWAMP_DRAGON_CATCH_FISH_SMALL_STRATEGY, true),
    SWAMP_DRAGON_CATCH_FISH_MIDDLE("catch_fish-middle", 600, AttackStrategy.SWAMP_DRAGON_CATCH_FISH_MIDDLE_STRATEGY, true),
    TUBUNASUS_ATTACK("attack", 20, AttackStrategy.TUBUNASUS_ATTACK_STRATEGY, true),
    TUBUNASUS_ATTACK_TURN("attack_turn", 45, AttackStrategy.TUBUNASUS_TURNING_ATTACK_STRATEGY, false, 15, true),
    SAEVUS_ATTACK("attack", 35, AttackStrategy.SAEVUS_ATTACK_STRATEGY, true),
    SAEVUS_ATTACK_TURN("attack_turn", 40, AttackStrategy.SAEVUS_ATTACK_TURN_STRATEGY, false, 10, true);

    private final String animName;
    private final int animationLength;
    private final AttackExecutor executor;
    private final boolean canMove;
    private final int stamina;
    private final boolean turning;

    private AttackType(String animName, int animationLength, AttackExecutor executor, boolean canMove, int stamina, boolean turning) {
        this.animName = animName;
        this.animationLength = animationLength;
        this.executor = executor;
        this.canMove = canMove;
        this.stamina = stamina;
        this.turning = turning;
    }

    private AttackType(String animName, int animationLength, AttackExecutor executor, boolean canMove) {
        this(animName, animationLength, executor, canMove, 0, false);
    }

    private AttackType(String animName, int animationLength, AttackExecutor executor, int stamina) {
        this(animName, animationLength, executor, false, stamina, false);
    }

    private AttackType(String animName, int animationLength, AttackExecutor executor) {
        this(animName, animationLength, executor, false);
    }

    public String getAnimName() {
        return this.animName;
    }

    public int getAnimationLength() {
        return this.animationLength;
    }

    public boolean canMove() {
        return this.canMove;
    }

    public int getStaminaCost() {
        return this.stamina;
    }

    public boolean isTurning() {
        return this.turning;
    }

    public void execute(MobAttack attack, ErsTamableVehicle<?> mount) {
        this.executor.execute(attack, mount);
    }
}

