/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity;

import cn.aurorian.ers.entity.AttackType;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class MobAttack {
    public AttackType type;
    public int animatorTick;
    ErsTamableVehicle<?> entity;
    public LivingEntity judgementTarget;
    public Vec3 turningAttackDirection = Vec3.f_82478_;
    public boolean triggered = false;
    public int triggerTime = 0;
    public boolean isSyncInstance = false;

    public MobAttack(AttackType type, ErsTamableVehicle<?> entity) {
        this.type = type;
        this.animatorTick = type.getAnimationLength();
        this.entity = entity;
    }

    public void tick() {
        if (this.isSyncInstance) {
            return;
        }
        if (!this.isEmpty()) {
            if (this.type.getStaminaCost() != 0) {
                this.entity.staminaCount = 0;
            }
            if (this.type != AttackType.EMPTY) {
                this.type.execute(this, this.entity);
            }
            if (this.animatorTick > 0) {
                --this.animatorTick;
            }
            if (this.animatorTick == 0) {
                this.entity.setAttackState(new MobAttack(AttackType.EMPTY, this.entity));
                this.triggered = false;
            }
        }
    }

    public int getAnimatorTick() {
        return this.animatorTick;
    }

    public boolean isFinished() {
        return this.animatorTick <= 0;
    }

    public AttackType getType() {
        return this.type;
    }

    public ErsTamableVehicle<?> getEntity() {
        return this.entity;
    }

    public boolean isEmpty() {
        return this.type == AttackType.EMPTY;
    }
}

