/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity.ai.goal;

import cn.aurorian.ers.entity.ErsTamableVehicle;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class MobFollowLeaderGoal
extends Goal {
    private final ErsTamableVehicle<?> mob;
    private final double speedModifier;
    private final double sprintModifier;
    private final float startDistanceSqr;
    private final float sprintDistanceSqr;
    private final float stopDistanceSqr;
    private boolean shouldSprint;
    private LivingEntity leader;
    private int timeToRecalcPath;

    public MobFollowLeaderGoal(ErsTamableVehicle<?> mob, double sprintModifier, float startDistance, float stopDistance) {
        this.mob = mob;
        this.speedModifier = 1.2;
        this.sprintModifier = sprintModifier;
        this.startDistanceSqr = startDistance * startDistance;
        this.sprintDistanceSqr = this.startDistanceSqr + 300.0f;
        this.stopDistanceSqr = stopDistance * stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.mob.updateLeader();
        ErsTamableVehicle<?> currentLeader = this.mob.leader;
        if (this.mob.m_20160_() || this.mob.m_6162_()) {
            return false;
        }
        if (currentLeader == null || currentLeader == this.mob) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(MobFollowLeaderGoal.m_186073_((int)70)) != 0) {
            return false;
        }
        if (this.mob.m_20280_((Entity)currentLeader) < (double)this.startDistanceSqr) {
            return false;
        }
        this.leader = currentLeader;
        return true;
    }

    public boolean m_8045_() {
        if (this.mob.m_21573_().m_26571_()) {
            return false;
        }
        double yDistanceSqr = Math.abs(this.mob.m_20186_() - this.leader.m_20186_());
        if (yDistanceSqr > (double)this.stopDistanceSqr && this.mob.m_20280_((Entity)this.leader) - yDistanceSqr < (double)this.stopDistanceSqr) {
            return false;
        }
        return this.mob.m_20280_((Entity)this.leader) > (double)this.stopDistanceSqr;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.shouldSprint = this.mob.m_20280_((Entity)this.leader) >= (double)this.sprintDistanceSqr;
        this.mob.m_6858_(this.shouldSprint);
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
        this.mob.m_6858_(false);
    }

    public void m_8037_() {
        this.mob.m_21563_().m_24960_((Entity)this.leader, 10.0f, (float)this.mob.m_8132_());
        --this.timeToRecalcPath;
        if (this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.m_183277_(100);
        if (this.mob.m_20280_((Entity)this.leader) >= (double)this.sprintDistanceSqr) {
            this.shouldSprint = true;
            this.mob.m_6858_(true);
        } else {
            this.mob.m_6858_(false);
        }
        this.mob.m_21573_().m_5624_((Entity)this.leader, this.shouldSprint ? this.sprintModifier : this.speedModifier);
    }
}

