/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.entity.creatures.dentisauruslongirostris;

import cn.aurorian.ers.effect.ErsBleedingEffect;
import cn.aurorian.ers.entity.AttackType;
import cn.aurorian.ers.entity.MobAttack;
import cn.aurorian.ers.entity.creatures.acanthodeschlamydoselachoides.AcanthodesChlamydoselachoidesEntity;
import cn.aurorian.ers.entity.creatures.dentisauruslongirostris.DentisaurusLongirostrisEntity;
import cn.aurorian.ers.entity.creatures.latimeriapercoides.LatimeriaPercoidesEntity;
import cn.aurorian.ers.init.ErsEntities;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.init.ErsParticleType;
import cn.aurorian.ers.util.ErsUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class DentisaurusLongirostrisAttackExecutor {
    private static final DentisaurusLongirostrisAttackExecutor INSTANCE = new DentisaurusLongirostrisAttackExecutor();

    public static DentisaurusLongirostrisAttackExecutor getInstance() {
        return INSTANCE;
    }

    public void executeSwampDragonAttack(MobAttack attack, DentisaurusLongirostrisEntity mount) {
        if (!mount.m_20160_()) {
            return;
        }
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK.getAnimationLength() - 9) {
            float scale = ErsUtils.calculateRenderSize(mount.getAgeInDays());
            double range = 2.5 * (double)scale;
            double damage = mount.m_21133_(Attributes.f_22281_);
            damage = this.checkEquipment(mount, (Item)ErsItems.BULLY_STICK.get()) ? damage * 1.4 : damage;
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y;
            double z = mount.m_20189_() + (double)foodPos.z;
            List entities = mount.m_9236_().m_6249_((Entity)mount, new AABB(x - range, y - range, z - range, x + range * 0.7, y + range, z + range * 0.7), entity -> entity instanceof LivingEntity && entity != mount && entity != mount.m_6688_());
            for (Entity entity2 : entities) {
                Level level;
                if (entity2 instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity2;
                    living.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), (float)damage);
                    ErsBleedingEffect.giveBleedingEffect(living, 4);
                    mount.m_20088_().m_135381_(DentisaurusLongirostrisEntity.BLOODY, (Object)true);
                }
                if (!((level = mount.m_9236_()) instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ErsParticleType.BLOOD.get()), x, y, z, 20, 0.3, 0.3, 0.3, 0.5);
            }
        }
    }

    public void executeSwampDragonJudgement(MobAttack attack, DentisaurusLongirostrisEntity mount) {
        if (attack.judgementTarget == null && !attack.triggered) {
            boolean swim;
            attack.triggered = true;
            float scale = ErsUtils.calculateRenderSize(mount.getAgeInDays());
            double range = 6.2 * (double)scale;
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y;
            double z = mount.m_20189_() + (double)foodPos.z;
            List entities = mount.m_9236_().m_6249_((Entity)mount, new AABB(x - range, y - range, z - range, x + range, y + range, z + range), entity -> entity instanceof LivingEntity && entity != mount && entity != mount.m_6688_());
            entities.removeIf(entity1 -> entity1.m_6972_((Pose)Pose.STANDING).f_20377_ >= 2.0f || entity1.m_6972_((Pose)Pose.STANDING).f_20378_ >= 3.0f);
            if (!mount.isElite()) {
                entities.removeIf(entity1 -> entity1.m_6972_((Pose)Pose.STANDING).f_20377_ >= 1.0f);
            }
            boolean bl = swim = mount.m_20069_() && !mount.m_20096_();
            if (!entities.isEmpty()) {
                LivingEntity closestEntity = null;
                double closestDistance = Double.MAX_VALUE;
                for (Entity entity2 : entities) {
                    double distance;
                    if (!(entity2 instanceof LivingEntity) || !((distance = mount.m_20280_(entity2)) < closestDistance)) continue;
                    closestDistance = distance;
                    closestEntity = (LivingEntity)entity2;
                }
                attack.judgementTarget = closestEntity != null ? closestEntity : (LivingEntity)entities.get(mount.m_9236_().f_46441_.m_188503_(entities.size()));
                if (swim) {
                    mount.triggerAnim("attack", "swim_attack");
                    attack.triggerTime = 40;
                } else if ((double)(attack.judgementTarget.m_6972_((Pose)Pose.STANDING).f_20378_ * attack.judgementTarget.m_6972_((Pose)Pose.STANDING).f_20377_ * attack.judgementTarget.m_6972_((Pose)Pose.STANDING).f_20377_) <= 0.648) {
                    mount.triggerAnim("attack", "attack2-small");
                    attack.triggerTime = 56;
                } else {
                    mount.triggerAnim("attack", "attack2-middle");
                    attack.triggerTime = 40;
                }
            } else if (swim) {
                mount.triggerAnim("attack", "swim_attack-miss");
            } else {
                mount.triggerAnim("attack", "attack2-miss");
                attack.triggerTime = 38;
            }
        }
        if (attack.judgementTarget == null && attack.animatorTick == AttackType.SWAMP_DRAGON_JUDGEMENT.getAnimationLength() - 40) {
            attack.animatorTick = 0;
        }
        if (attack.animatorTick >= 0 && attack.judgementTarget != null) {
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y + 0.1;
            double z = mount.m_20189_() + (double)foodPos.z;
            attack.judgementTarget.m_20334_(0.0, 0.0, 0.0);
            attack.judgementTarget.m_146926_(90.0f);
            attack.judgementTarget.m_146922_(90.0f);
            attack.judgementTarget.m_6034_(x, y, z);
            if (attack.animatorTick == AttackType.SWAMP_DRAGON_JUDGEMENT.getAnimationLength() - attack.triggerTime) {
                LivingEntity livingEntity = attack.judgementTarget;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    player.m_21153_(0.1f);
                    player.m_7911_(0.0f);
                    player.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), player.m_21233_());
                }
                attack.judgementTarget.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), Float.MAX_VALUE);
                mount.m_20088_().m_135381_(DentisaurusLongirostrisEntity.BLOODY, (Object)true);
                livingEntity = mount.m_9236_();
                if (livingEntity instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)livingEntity;
                    mount.m_5634_(10.0f);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ErsParticleType.BLOOD.get()), x, y, z, 100, 0.3, 0.3, 0.3, 0.1);
                }
            }
        }
    }

    public void executeSwampDragonSpecialAttack(MobAttack attack, DentisaurusLongirostrisEntity mount) {
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_SPECIAL_ATTACK.getAnimationLength() - 13 || attack.animatorTick == AttackType.SWAMP_DRAGON_SPECIAL_ATTACK.getAnimationLength() - 29 || attack.animatorTick == AttackType.SWAMP_DRAGON_SPECIAL_ATTACK.getAnimationLength() - 49) {
            Level target2;
            Vec3 lookVec = mount.m_20154_();
            Vec3 pos = mount.m_20182_();
            float scale = ErsUtils.calculateRenderSize(mount.getAgeInDays());
            double length = 4.0f * scale;
            double range = 4.0f * scale;
            double startX = pos.f_82479_ + lookVec.f_82479_ * length;
            double startY = pos.f_82480_ + lookVec.f_82480_;
            double startZ = pos.f_82481_ + lookVec.f_82481_ * length;
            AABB attackBox = new AABB(startX - range, startY, startZ - range, startX + range, startY + range, startZ + range);
            List entities = mount.m_9236_().m_6249_((Entity)mount, attackBox, entity -> entity instanceof LivingEntity);
            double damage = mount.m_21133_(Attributes.f_22281_);
            damage = this.checkEquipment(mount, (Item)ErsItems.SCRATCHING_BOARD.get()) ? damage * 1.4 : damage;
            for (Level target2 : entities) {
                if (target2.equals((Object)mount.m_6688_()) || !(target2 instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)target2;
                livingEntity.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), (float)damage);
                ErsBleedingEffect.giveBleedingEffect(livingEntity, 4);
                mount.m_20088_().m_135381_(DentisaurusLongirostrisEntity.BLOODY, (Object)true);
            }
            target2 = mount.m_9236_();
            if (target2 instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)target2;
                for (int i = 0; i < 10; ++i) {
                    double particleX = attackBox.f_82288_ + mount.m_217043_().m_188500_() * (attackBox.f_82291_ - attackBox.f_82288_);
                    double particleY = attackBox.f_82289_ + mount.m_217043_().m_188500_() * (attackBox.f_82292_ - attackBox.f_82289_);
                    double particleZ = attackBox.f_82290_ + mount.m_217043_().m_188500_() * (attackBox.f_82293_ - attackBox.f_82290_);
                    if (mount.m_20069_()) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, particleX, particleY, particleZ, 6, 0.3, 0.3, 0.3, 0.1);
                        continue;
                    }
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123815_, particleX, particleY, particleZ, 6, 0.3, 0.3, 0.3, 0.1);
                }
            }
        }
    }

    public void executeSwampDragonTurningAttack(MobAttack attack, DentisaurusLongirostrisEntity mount) {
        Player player;
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK_TURN.getAnimationLength() - 20 || attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK_TURN.getAnimationLength() - 10) {
            player = (Player)mount.m_6688_();
            if (player == null) {
                return;
            }
            Vec3 lookVec = player.m_20154_();
            Vec3 pos = mount.m_20182_();
            double range = 3.2;
            double startX = pos.f_82479_ + lookVec.f_82479_ * range;
            double startY = pos.f_82480_ + lookVec.f_82480_;
            double startZ = pos.f_82481_ + lookVec.f_82481_ * range;
            AABB attackBox = new AABB(startX - range, startY, startZ - range, startX + range, startY + range, startZ + range);
            List entities = mount.m_9236_().m_6249_((Entity)mount, attackBox, entity -> entity instanceof LivingEntity);
            double damage = mount.m_21133_(Attributes.f_22281_) + 5.0;
            damage = this.checkEquipment(mount, (Item)ErsItems.BULLY_STICK.get()) ? damage * 1.4 : damage;
            for (Entity target : entities) {
                if (target.equals((Object)mount.m_6688_()) || !(target instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)target;
                livingEntity.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), (float)damage);
                ErsBleedingEffect.giveBleedingEffect(livingEntity, 4);
                mount.m_20088_().m_135381_(DentisaurusLongirostrisEntity.BLOODY, (Object)true);
            }
        }
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK_TURN.getAnimationLength() - 1) {
            player = (Player)mount.m_6688_();
            attack.turningAttackDirection = player.m_20154_().m_82541_();
        }
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK_TURN.getAnimationLength() - 16 || attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK_TURN.getAnimationLength() - 18 || attack.animatorTick == AttackType.SWAMP_DRAGON_ATTACK_TURN.getAnimationLength() - 20) {
            mount.m_20334_(attack.turningAttackDirection.f_82479_ * 1.7, 0.0, attack.turningAttackDirection.f_82481_ * 1.7);
        }
    }

    public void executeSwampDragonCatchFishSmall(MobAttack attack, DentisaurusLongirostrisEntity mount) {
        Level level;
        if (attack.getType() != AttackType.SWAMP_DRAGON_CATCH_FISH_SMALL) {
            return;
        }
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_CATCH_FISH_SMALL.getAnimationLength() - 470 && attack.judgementTarget == null && !attack.triggered && (level = mount.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            System.out.println(attack);
            attack.judgementTarget = (LivingEntity)Objects.requireNonNull((LatimeriaPercoidesEntity)((EntityType)ErsEntities.LATIMERIA_PERCOIDES.get()).m_20615_((Level)serverLevel));
            serverLevel.m_7967_((Entity)attack.judgementTarget);
            attack.triggered = true;
        }
        if (attack.animatorTick >= 0 && attack.judgementTarget != null) {
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y + 0.1;
            double z = mount.m_20189_() + (double)foodPos.z;
            attack.judgementTarget.m_20334_(0.0, 0.0, 0.0);
            attack.judgementTarget.m_146926_(90.0f);
            attack.judgementTarget.m_146922_(90.0f);
            attack.judgementTarget.m_6034_(x, y, z);
            if (attack.animatorTick == AttackType.SWAMP_DRAGON_CATCH_FISH_SMALL.getAnimationLength() - 558) {
                attack.judgementTarget.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), Float.MAX_VALUE);
                mount.m_20088_().m_135381_(DentisaurusLongirostrisEntity.BLOODY, (Object)true);
                Level level2 = mount.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    mount.m_5634_(10.0f);
                    mount.feed(2);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ErsParticleType.BLOOD.get()), x, y, z, 100, 0.3, 0.3, 0.3, 0.1);
                }
            }
        }
        if (attack.animatorTick == 0) {
            mount.getAnimatableInstanceCache().getManagerForId((long)mount.m_19879_()).stopTriggeredAnimation("catch_fish-small");
        }
    }

    public void executeSwampDragonCatchFishMiddle(MobAttack attack, DentisaurusLongirostrisEntity mount) {
        Level level;
        if (attack.getType() != AttackType.SWAMP_DRAGON_CATCH_FISH_MIDDLE) {
            return;
        }
        if (attack.animatorTick == AttackType.SWAMP_DRAGON_CATCH_FISH_MIDDLE.getAnimationLength() - 470 && attack.judgementTarget == null && !attack.triggered && (level = mount.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            System.out.println(attack);
            attack.judgementTarget = (LivingEntity)Objects.requireNonNull((AcanthodesChlamydoselachoidesEntity)((EntityType)ErsEntities.ACANTHODES_CHLAMYDOSELACHOIDES.get()).m_20615_((Level)serverLevel));
            serverLevel.m_7967_((Entity)attack.judgementTarget);
            attack.triggered = true;
        }
        if (attack.animatorTick >= 0 && attack.judgementTarget != null) {
            Vector3f foodPos = mount.getFoodPosition();
            double x = mount.m_20185_() + (double)foodPos.x;
            double y = mount.m_20186_() + (double)foodPos.y + 0.1;
            double z = mount.m_20189_() + (double)foodPos.z;
            attack.judgementTarget.m_20334_(0.0, 0.0, 0.0);
            attack.judgementTarget.m_146926_(90.0f);
            attack.judgementTarget.m_146922_(90.0f);
            attack.judgementTarget.m_6034_(x, y, z);
            if (attack.animatorTick == AttackType.SWAMP_DRAGON_CATCH_FISH_MIDDLE.getAnimationLength() - 540) {
                attack.judgementTarget.m_6469_(mount.m_9236_().m_269111_().m_269333_((LivingEntity)mount), Float.MAX_VALUE);
                mount.m_20088_().m_135381_(DentisaurusLongirostrisEntity.BLOODY, (Object)true);
                Level level2 = mount.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level2;
                    mount.m_5634_(12.0f);
                    mount.feed(3);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ErsParticleType.BLOOD.get()), x, y, z, 100, 0.3, 0.3, 0.3, 0.1);
                }
            }
        }
        if (attack.animatorTick == 0) {
            mount.getAnimatableInstanceCache().getManagerForId((long)mount.m_19879_()).stopTriggeredAnimation("catch_fish-middle");
        }
    }

    public boolean checkEquipment(DentisaurusLongirostrisEntity mount, Item equipment) {
        for (int i = 5; i <= 7; ++i) {
            ItemStack itemStack = mount.getInventory().m_8020_(i);
            if (itemStack.m_41619_() || !itemStack.m_150930_(equipment)) continue;
            return true;
        }
        return false;
    }
}

