/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.event;

import com.mojang.logging.LogUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PacketListener {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void onClientPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        try {
            String packetInfo = context.getNetworkManager().m_129523_().toString();
            LOGGER.info("\u63a5\u6536\u5230\u6570\u636e\u5305\uff0c\u6765\u81ea: {}", (Object)packetInfo);
            if (buf != null && buf.readableBytes() > 0) {
                FriendlyByteBuf copy = new FriendlyByteBuf(buf.copy());
                byte[] data = new byte[copy.readableBytes()];
                copy.readBytes(data);
                LOGGER.info("\u6570\u636e\u5305\u5185\u5bb9: {}", (Object)PacketListener.bytesToHex(data));
                copy.release();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u6570\u636e\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X ", b));
        }
        return sb.toString();
    }
}

