/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.packet;

import cn.aurorian.ers.entity.ErsTamableVehicle;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class MobAttackPacket {
    private final int entityId;
    private final int attackId;

    public MobAttackPacket(int entityId, int attackId) {
        this.entityId = entityId;
        this.attackId = attackId;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.attackId);
    }

    public static MobAttackPacket decode(FriendlyByteBuf buf) {
        return new MobAttackPacket(buf.readInt(), buf.readInt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                ErsTamableVehicle tamable = (ErsTamableVehicle)((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_6815_(this.entityId);
                if (tamable == null) {
                    return;
                }
                switch (this.attackId) {
                    case 1: {
                        tamable.executeDefaultAttackType();
                        break;
                    }
                    case 2: {
                        tamable.executeSpecialAttackType();
                        break;
                    }
                    case 3: {
                        tamable.executeJudgementAttackType();
                        break;
                    }
                    case 4: {
                        tamable.executeTurnAttackType();
                        break;
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

