/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.packet;

import cn.aurorian.ers.entity.ErsPlayerRideable;
import cn.aurorian.ers.entity.MobRotDirection;
import cn.aurorian.ers.init.ErsNetwork;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MobTurnPacket {
    private final MobRotDirection direction;
    private final int entityId;

    public MobTurnPacket(int entityId, MobRotDirection diving) {
        this.entityId = entityId;
        this.direction = diving;
    }

    public MobTurnPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.direction = MobRotDirection.of(MobRotDirection.RotDirection.values()[buf.readInt()], buf.readBoolean());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.direction.getDirection().ordinal());
        buf.writeBoolean(this.direction.isLargeTurn());
    }

    public static MobTurnPacket decode(FriendlyByteBuf buf) {
        return new MobTurnPacket(buf.readInt(), MobRotDirection.of(MobRotDirection.RotDirection.values()[buf.readInt()], buf.readBoolean()));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isClient()) {
                Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
                if (entity instanceof ErsPlayerRideable) {
                    ErsPlayerRideable rideable = (ErsPlayerRideable)entity;
                    rideable.setRotDirection(this.direction);
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            } else {
                Entity entity = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_6815_(this.entityId);
                if (entity instanceof ErsPlayerRideable) {
                    ErsPlayerRideable rideable = (ErsPlayerRideable)entity;
                    rideable.setRotDirection(this.direction);
                }
                ErsNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MobTurnPacket(this.entityId, this.direction));
            }
        });
    }
}

