/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.packet;

import cn.aurorian.ers.entity.ErsTamableVehicle;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class VehicleDivePacket {
    private final boolean diving;
    private final int entityId;

    public VehicleDivePacket(int entityId, boolean diving) {
        this.entityId = entityId;
        this.diving = diving;
    }

    public VehicleDivePacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.diving = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.diving);
    }

    public static VehicleDivePacket decode(FriendlyByteBuf buf) {
        return new VehicleDivePacket(buf.readInt(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(this.entityId)) instanceof ErsTamableVehicle) {
                    ErsTamableVehicle tamable = (ErsTamableVehicle)entity;
                    tamable.onDiveKeyUpdate(this.diving);
                    if (this.diving) {
                        tamable.setSwimState(2);
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        });
    }
}

