/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.ers.packet;

import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.init.ErsMobEffects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class VehicleSprintPacket {
    private final boolean sprint;
    private final int entityId;

    public VehicleSprintPacket(int entityId, boolean diving) {
        this.entityId = entityId;
        this.sprint = diving;
    }

    public VehicleSprintPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.sprint = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.sprint);
    }

    public static VehicleSprintPacket decode(FriendlyByteBuf buf) {
        return new VehicleSprintPacket(buf.readInt(), buf.readBoolean());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide().isServer()) {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(this.entityId)) instanceof ErsTamableVehicle) {
                    ErsTamableVehicle vehicle = (ErsTamableVehicle)entity;
                    if (vehicle.m_21023_((MobEffect)ErsMobEffects.FRACTURE.get())) {
                        return;
                    }
                    if (player.m_20069_()) {
                        entity.m_6858_(this.sprint);
                        player.m_6858_(false);
                    } else {
                        entity.m_6858_(false);
                        player.m_6858_(this.sprint);
                    }
                }
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        });
    }
}

