/*
 * Decompiled with CFR 0.152.
 */
package cn.aurorian.oasis.entity.tubunasusclyderotunda;

import cn.aurorian.ers.client.animator.GeneralAnimator;
import cn.aurorian.ers.entity.ErsSaddleable;
import cn.aurorian.ers.entity.ErsTamableVehicle;
import cn.aurorian.ers.entity.ai.goal.MobAlertLeaderGoal;
import cn.aurorian.ers.entity.ai.goal.MobFollowLeaderGoal;
import cn.aurorian.ers.entity.ai.goal.MobWanderGoal;
import cn.aurorian.ers.entity.ai.movecontrol.LimitedMoveControl;
import cn.aurorian.ers.entity.ai.navigation.MMGroundPathNavigation;
import cn.aurorian.ers.init.ErsItems;
import cn.aurorian.ers.item.ErsMobLargeBucket;
import cn.aurorian.ers.item.equipment.MountEquipment;
import cn.aurorian.ers.util.ErsUtils;
import cn.aurorian.ers.util.TickHelper;
import cn.aurorian.oasis.client.animator.ClyderotundaTubunasusAnimator;
import cn.aurorian.oasis.entity.tubunasusclyderotunda.TubunasusClyderotundaBodyControl;
import cn.aurorian.oasis.entity.tubunasusclyderotunda.ai.TubunasusClyderotundaMeleeAttackGoal;
import cn.aurorian.oasis.init.OasisItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class TubunasusClyderotundaEntity
extends ErsTamableVehicle<TubunasusClyderotundaEntity>
implements ErsSaddleable,
ContainerListener,
HasCustomInventoryScreen,
Bucketable {
    private final GeneralAnimator<TubunasusClyderotundaEntity> animator = new ClyderotundaTubunasusAnimator(this);
    private boolean stableHead = false;
    private int rushTimer = 0;
    private boolean crush = false;
    private static final EntityDataAccessor<Boolean> DATA_SADDLED = SynchedEntityData.m_135353_(TubunasusClyderotundaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> NEXT_CHANGE_TIME = SynchedEntityData.m_135353_(TubunasusClyderotundaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SAIL = SynchedEntityData.m_135353_(TubunasusClyderotundaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SCALE = SynchedEntityData.m_135353_(TubunasusClyderotundaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(TubunasusClyderotundaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DEAD_PROGRESS = SynchedEntityData.m_135353_(TubunasusClyderotundaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected SimpleContainer inventory;
    private static final float ACCELERATION = 0.08f;
    private int buckingTimer = -1;

    public TubunasusClyderotundaEntity(EntityType<? extends ErsTamableVehicle> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.f_21342_ = new LimitedMoveControl((Mob)this);
        this.switchNavigator(true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.createInventory();
    }

    protected void switchNavigator(boolean onLand) {
        this.f_21344_ = onLand ? new MMGroundPathNavigation((Mob)this, this.m_9236_()) : new AmphibiousPathNavigation((Mob)this, this.m_9236_());
    }

    public int getRushTimer() {
        return this.rushTimer;
    }

    @Override
    public void setStableHead(boolean stableHead) {
        this.stableHead = stableHead;
    }

    @Override
    public boolean getStableHead() {
        return this.stableHead;
    }

    @Override
    public GeneralAnimator<TubunasusClyderotundaEntity> getAnimator() {
        return this.animator;
    }

    public boolean isSailUp() {
        return (Boolean)this.f_19804_.m_135370_(SAIL);
    }

    public void setSailUp(boolean sail) {
        this.f_19804_.m_135381_(SAIL, (Object)sail);
    }

    public float m_6134_() {
        return ((Float)this.f_19804_.m_135370_(SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(SCALE, (Object)Float.valueOf(Math.clamp((float)scale, (float)0.9f, (float)1.1f)));
    }

    @Override
    public int getInventorySize() {
        return 7;
    }

    public int getDeadProgress() {
        return (Integer)this.f_19804_.m_135370_(DEAD_PROGRESS);
    }

    public void setDeadProgress(int progress) {
        this.f_19804_.m_135381_(DEAD_PROGRESS, (Object)progress);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + this.f_19796_.m_216332_(200, 400)));
        this.f_19804_.m_135372_(SAIL, (Object)true);
        this.f_19804_.m_135372_(SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(DEAD_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(DATA_SADDLED, (Object)false);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.getDeadProgress() == 0) {
            ListTag itemsList = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack stack = this.inventory.m_8020_(i);
                if (stack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", i);
                stack.m_41739_(itemTag);
                itemsList.add((Object)itemTag);
            }
            compoundTag.m_128365_("Items", (Tag)itemsList);
        }
        if (this.m_8077_()) {
            compoundTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
        compoundTag.m_128379_("saddled", this.isSaddled());
        compoundTag.m_128350_("Scale", this.m_6134_());
        compoundTag.m_128405_("DeadProgress", this.getDeadProgress());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (this.getDeadProgress() == 0) {
            this.inventory.m_6211_();
            ListTag itemsList = compound.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTag = itemsList.m_128728_(i);
                int slot = itemTag.m_128451_("Slot");
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                if (stack.m_41619_() || slot < 0 || slot >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(slot, stack);
            }
        }
        if (compound.m_128441_("CustomName")) {
            this.m_6593_((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
        this.setSaddled(compound.m_128471_("saddled"));
        this.setScale(compound.m_128457_("Scale"));
        this.setDeadProgress(compound.m_128451_("DeadProgress"));
    }

    public void m_213583_(@NotNull Player player) {
    }

    protected void m_6153_() {
        if (this.getDeadProgress() == 0) {
            this.setDeadProgress(1);
        }
        this.m_20153_();
        if (this.getDeadProgress() >= 8) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack stack = this.inventory.m_8020_(i);
            this.m_19983_(stack);
            this.inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TubunasusClyderotundaMeleeAttackGoal(this, 2.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MobWanderGoal(this, 1.1, 40){

            public boolean m_8036_() {
                return super.m_8036_() && ((TubunasusClyderotundaEntity)this.f_25725_).leader == this.f_25725_;
            }
        }.setWaterVerticalRange(0));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, TubunasusClyderotundaEntity.class, 8.0f, 1.1, 2.1));
        this.f_21345_.m_25352_(3, (Goal)new MobFollowLeaderGoal(this, 2.1, 14.0f, 10.0f));
        this.f_21345_.m_25352_(1, (Goal)new MobAlertLeaderGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true, mob -> this.leader != null && this.leader.m_5448_() == mob));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        AnimationController main = new AnimationController((GeoAnimatable)this, "main", 2, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.getDeadProgress() != 0) {
                return PlayState.STOP;
            }
            if (this.m_20069_() && !this.m_20096_()) {
                if (this.m_20142_()) {
                    builder.thenLoop("animation.swim");
                } else if (ErsUtils.isMoving((Mob)this)) {
                    builder.thenLoop("animation.swim2");
                } else {
                    builder.thenLoop("animation.swim_idle");
                }
            } else if (this.m_20142_()) {
                builder.thenLoop("animation.run");
                if (this.rushTimer < 75) {
                    builder.thenLoop("animation.run");
                } else if (this.rushTimer < 167) {
                    builder.thenLoop("animation.run2");
                } else {
                    builder.thenLoop("animation.run3");
                }
            } else if (state.isMoving() || ErsUtils.isMoving((Mob)this)) {
                builder.thenLoop("animation.walk");
            } else if (!this.getRotDirection().isNone()) {
                if (this.getRotDirection().isLeft()) {
                    builder.thenLoop("animation.turn_-left");
                } else {
                    builder.thenLoop("animation.turn_+right");
                }
            } else {
                builder.thenLoop("animation.idle");
            }
            return state.setAndContinue(builder);
        });
        AnimationController extra = new AnimationController((GeoAnimatable)this, "extra", 2, state -> PlayState.STOP).triggerableAnim("idle2", RawAnimation.begin().thenPlay("animation.idle_eat")).triggerableAnim("idle3", RawAnimation.begin().thenPlay("animation.idle_lookAround")).triggerableAnim("taming", RawAnimation.begin().thenPlay("animation.taming"));
        AnimationController attack = new AnimationController((GeoAnimatable)this, "attack", 4, state -> PlayState.STOP).triggerableAnim("attack", RawAnimation.begin().thenPlay("animation.attack")).triggerableAnim("attack_turn", RawAnimation.begin().thenPlay("animation.attack_turn"));
        AnimationController control = new AnimationController((GeoAnimatable)this, "control", 0, state -> {
            RawAnimation builder = RawAnimation.begin();
            if (this.isSailUp()) {
                builder.thenPlayAndHold("animation.open");
            } else {
                builder.thenPlayAndHold("animation.close");
            }
            return state.setAndContinue(builder);
        });
        controllerRegistrar.add(new AnimationController[]{main, extra, attack, control});
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player player, @NotNull Vec3 pVec, @NotNull InteractionHand pHand) {
        if (this.getDeadProgress() != 0) {
            if (player.m_21120_(pHand).m_41720_() instanceof SwordItem || player.m_21120_(pHand).m_41720_() instanceof AxeItem) {
                this.getRandomDrop(this.getDeadProgress());
                this.m_216990_(SoundEvents.f_11710_);
                this.setDeadProgress(this.getDeadProgress() + 1);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return super.m_7111_(player, pVec, pHand);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand pHand) {
        if (player.m_21205_().m_41720_() == ErsItems.LARGE_WATER_BUCKET.get() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            return ErsMobLargeBucket.bucketMobPickup(player, pHand, this).orElse(InteractionResult.PASS);
        }
        if (!player.m_6047_()) {
            if (this.m_21824_() && !this.m_21830_((LivingEntity)player) && this.m_20197_().isEmpty()) {
                return InteractionResult.PASS;
            }
            player.m_146922_(this.m_146908_());
            player.m_146926_(this.m_146909_());
            player.m_20329_((Entity)this);
        }
        return super.m_6071_(player, pHand);
    }

    private void getRandomDrop(int progress) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        switch (progress) {
            case 2: {
                this.spawnLeather(1, 2);
                break;
            }
            case 3: {
                this.m_5552_(new ItemStack((ItemLike)OasisItems.HEART.get(), 1), 1.0f);
                this.spawnChanceLeather(0.667f);
                break;
            }
            case 4: {
                this.m_5552_(new ItemStack((ItemLike)OasisItems.INTESTINES.get(), 1), 1.0f);
                this.m_5552_(new ItemStack((ItemLike)OasisItems.KIDNEY.get(), 1), 1.0f);
                this.spawnChanceLeather(0.667f);
                break;
            }
            case 5: {
                this.m_5552_(new ItemStack((ItemLike)OasisItems.LUNG.get(), 1), 1.0f);
                this.spawnChanceLeather(0.667f);
                break;
            }
            case 6: {
                this.m_5552_(new ItemStack((ItemLike)OasisItems.LIVER.get(), this.f_19796_.m_216332_(2, 3)), 1.0f);
                this.spawnChanceLeather(0.667f);
                break;
            }
            case 7: {
                this.m_5552_(new ItemStack((ItemLike)OasisItems.BONE.get(), this.f_19796_.m_216332_(3, 5)), 1.0f);
                break;
            }
        }
    }

    private void spawnChanceLeather(float chance) {
        if (this.f_19796_.m_188501_() < chance) {
            this.spawnLeather(1, 2);
        }
    }

    private void spawnLeather(int min, int max) {
        ItemStack drop = new ItemStack((ItemLike)OasisItems.LEATHER.get(), this.f_19796_.m_216332_(min, max));
        this.m_5552_(drop, 1.0f);
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 1.0f);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new TubunasusClyderotundaBodyControl(this);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 4.0).m_22268_(Attributes.f_22279_, 0.15);
    }

    protected boolean m_7310_(@NotNull Entity pPassenger) {
        return this.m_20197_().size() < 2 && !this.m_20142_();
    }

    public boolean m_6094_() {
        return !this.m_20096_();
    }

    public boolean m_21525_() {
        return super.m_21525_() || !this.m_6084_();
    }

    public boolean m_5829_() {
        return true;
    }

    @Override
    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity passenger = (LivingEntity)this.m_146895_();
        if (passenger == null) {
            return null;
        }
        return this.m_21830_(passenger) ? passenger : null;
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        if (this.isInFluidType() && !this.m_20096_()) {
            float y = 0.0f;
            if (pPlayer.f_20899_ && this.getSwimState() == 2) {
                y = 0.4f;
                if (!this.f_19800_) {
                    this.setSwimState(1);
                }
            }
            if (this.rideSpeed != 0.0f && this.getSwimState() == 1 && this.f_19862_) {
                y = 0.6f;
            }
            if (this.isSailUp()) {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(10.0);
            } else {
                this.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get()).m_22100_(4.0);
            }
            return new Vec3(0.0, (double)y, (double)this.rideSpeed);
        }
        if (this.crush) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return new Vec3(0.0, 0.0, (double)this.rideSpeed);
    }

    protected void m_274498_(@NotNull Player driver, @NotNull Vec3 move) {
        this.tickStableHead();
        if (this.getAttackState().getType().canMove() && this.isSaddled()) {
            if ((!this.getRotDirection().isLargeTurn() || this.m_20069_()) && (Math.abs((float)driver.f_20902_) > 0.0f || Math.abs((float)driver.f_20900_) > 0.0f) || this.m_20142_()) {
                float baseSpeed = (float)this.m_21051_(Attributes.f_22279_).m_22135_();
                if (this.rushTimer > 75) {
                    baseSpeed *= 1.2f;
                    if (this.rushTimer > 167) {
                        baseSpeed *= 1.2f;
                    }
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                }
                this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)(this.m_20142_() ? baseSpeed * 2.2f : baseSpeed), (float)0.08f);
            } else {
                this.rideSpeed = Mth.m_14121_((float)this.rideSpeed, (float)0.0f, (float)0.16f);
            }
        }
    }

    public void tickStableHead() {
        float pitch = this.getAnimator().getModelPitch(this.getAnimator().getPartialTick());
        if (this.m_20069_()) {
            this.setStableHead(pitch < 20.0f);
        } else if (this.m_20096_()) {
            this.setStableHead(true);
        }
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return this.rideSpeed + 0.2f;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_20069_() && this.f_21344_ instanceof MMGroundPathNavigation) {
            this.switchNavigator(false);
        } else if (!this.m_20069_() && this.f_21344_ instanceof AmphibiousPathNavigation) {
            this.switchNavigator(true);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.waterAiStep(2.4f);
        this.breakBlock();
        this.checkAndBreakBlocksAhead();
    }

    public boolean m_6084_() {
        return super.m_6084_() || this.getDeadProgress() == 0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        if (this.m_9236_().f_46443_ && this.f_19797_ > (Integer)this.f_19804_.m_135370_(NEXT_CHANGE_TIME)) {
            this.f_19804_.m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(200, 400)));
            int newState = RandomSource.m_216327_().m_188503_(3);
            if (newState != 0 && !ErsUtils.isMoving((Mob)this) && !this.m_20069_()) {
                if (newState == 1) {
                    this.triggerAnim("extra", "idle2");
                } else {
                    this.triggerAnim("extra", "idle3");
                }
            }
        }
        boolean hasHorseShoe = false;
        for (int i = 4; i <= 6; ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            if (item instanceof MountEquipment) {
                MountEquipment mountEquipment = (MountEquipment)item;
            }
            if (!itemStack.m_150930_((Item)OasisItems.HORSESHOE.get())) continue;
            hasHorseShoe = true;
        }
        this.rushTimer = this.m_20142_() && !this.m_20069_() ? ++this.rushTimer : 0;
        if (this.m_20142_()) {
            float damage;
            float f = damage = this.rushTimer > 75 ? 6.0f : 3.0f;
            if (this.rushTimer > 167) {
                damage = 21.0f;
            }
            if (hasHorseShoe) {
                damage += 4.0f;
            }
            this.stompEffect(3.0f, 3.0f, damage);
        }
        if (this.crush && this.f_19797_ % 40 == 0) {
            this.crush = false;
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 200 == 0) {
                this.m_5634_(1.0f);
                this.updateLeader();
            }
            if (this.m_21824_()) {
                return;
            }
            Player player = (Player)this.m_146895_();
            if (player != null && !this.m_21830_((LivingEntity)player)) {
                if (this.buckingTimer == -1) {
                    this.buckingTimer = Mth.m_216287_((RandomSource)this.f_19796_, (int)100, (int)200);
                }
                --this.buckingTimer;
                if (this.buckingTimer % 20 == 0 && (double)this.f_19796_.m_188501_() < 0.05) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                }
                if (this.buckingTimer <= 0 && !this.m_21824_()) {
                    player.m_8127_();
                    this.m_6710_((LivingEntity)player);
                    player.m_20334_(0.0, 10.0, 0.0);
                    TickHelper.tickLater(this.m_9236_(), 3, () -> this.triggerAnim("extra", "taming"));
                    this.m_5496_(SoundEvents.f_11972_, 1.0f, 1.0f);
                    if (this.leader != this) {
                        TickHelper.tickLater(this.m_9236_(), 20, () -> {
                            if (this.leader != null) {
                                this.m_6710_(null);
                            }
                        });
                    }
                    this.buckingTimer = -1;
                }
            } else {
                this.buckingTimer = -1;
            }
        }
        if (ErsUtils.isMoving((Mob)this)) {
            this.updateMount();
        }
    }

    @Override
    public void updateMount() {
        this.m_20088_().m_135381_(NEXT_CHANGE_TIME, (Object)(this.f_19797_ + RandomSource.m_216327_().m_216332_(200, 400)));
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle2");
        this.getAnimatableInstanceCache().getManagerForId((long)this.m_19879_()).stopTriggeredAnimation("idle3");
    }

    public void m_20321_(boolean pDownwards) {
    }

    public void m_7601_(@NotNull BlockState pState, @NotNull Vec3 pMotionMultiplier) {
    }

    public int m_5792_() {
        return 5;
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_269415_().f_268677_().equals("sweetBerryBush")) {
            return true;
        }
        return super.m_6673_(source);
    }

    private void checkAndBreakBlocksAhead() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
            return;
        }
        if (this.rushTimer < 75) {
            return;
        }
        Direction facing = this.m_6350_();
        BlockPos centerPos = this.m_20183_().m_5484_(facing, 2);
        boolean shouldStop = false;
        float stoneDestroyTime = Blocks.f_152550_.m_49966_().m_60800_((BlockGetter)this.m_9236_(), BlockPos.f_121853_);
        for (int xOffset = 0; xOffset < 2; ++xOffset) {
            for (int yOffset = 1; yOffset < 3; ++yOffset) {
                BlockPos checkPos = centerPos.m_7918_(facing.m_122434_() == Direction.Axis.X ? 0 : xOffset, yOffset, facing.m_122434_() == Direction.Axis.Z ? 0 : xOffset);
                BlockState state = this.m_9236_().m_8055_(checkPos);
                Block block = state.m_60734_();
                float destroyTime = state.m_60800_((BlockGetter)this.m_9236_(), checkPos);
                if (state.m_60815_() && state.m_60804_((BlockGetter)this.m_9236_(), checkPos)) {
                    shouldStop = true;
                }
                if (!(destroyTime < stoneDestroyTime) || !(destroyTime > 0.0f) || !(block.m_7325_() <= 1200.0f)) continue;
                this.m_9236_().m_46953_(checkPos, true, (Entity)this);
            }
        }
        if (shouldStop) {
            this.crush = true;
            this.m_6858_(false);
        }
    }

    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.BUCKET) {
            return pSpawnData;
        }
        SpawnGroupData throwedSpawnData = pSpawnData;
        if (pSpawnData == null) {
            pSpawnData = throwedSpawnData;
        }
        this.setScale(Mth.m_216283_((RandomSource)this.f_19796_, (float)0.9f, (float)1.1f));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose pPose) {
        float scale = this.m_6134_();
        return this.m_6095_().m_20680_().m_20388_(scale);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean pFromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)pFromBucket);
    }

    public void m_6872_(ItemStack pStack) {
        this.m_7380_(pStack.m_41784_());
    }

    public void m_142278_(@NotNull CompoundTag pTag) {
        this.m_7378_(pTag);
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)OasisItems.TUBUNASUS_DUROVELA_LARGE_BUCKET.get());
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void m_5757_(@NotNull Container container) {
        this.setSaddled(!this.inventory.m_8020_(0).m_41619_());
        boolean healthBoost = false;
        boolean armorBoost = false;
        for (int i = 4; i <= 6; ++i) {
            ItemStack itemStack = this.inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_150930_(Items.f_42437_)) {
                healthBoost = true;
            }
            if (!itemStack.m_150930_(Items.f_42740_)) continue;
            armorBoost = true;
        }
        if (healthBoost) {
            this.m_21051_(Attributes.f_22276_).m_22100_(270.0);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(250.0);
        }
        if (armorBoost) {
            this.m_21051_(Attributes.f_22284_).m_22100_(10.0);
        } else {
            this.m_21051_(Attributes.f_22284_).m_22100_(6.0);
        }
    }

    @Override
    public boolean isSaddleable() {
        return this.m_6084_() && this.m_21824_();
    }

    @Override
    public void equipSaddle(@Nullable SoundSource soundSource) {
        this.inventory.m_6836_(0, new ItemStack((ItemLike)OasisItems.TUBUNASUS_SADDLE.get()));
        this.setSaddled(true);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12034_, this.m_5720_(), 1.0f, 1.0f);
    }

    @Override
    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(DATA_SADDLED);
    }

    @Override
    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(DATA_SADDLED, (Object)saddled);
    }
}

