/*
 * Decompiled with CFR 0.152.
 */
package winlyps.villagerProfession.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Bukkit;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.entity.VillagerCareerChangeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import winlyps.villagerProfession.listeners.VanillaTradeGenerator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lwinlyps/villagerProfession/listeners/VillagerListener;", "Lorg/bukkit/event/Listener;", "plugin", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "(Lorg/bukkit/plugin/java/JavaPlugin;)V", "onVillagerSpawn", "", "event", "Lorg/bukkit/event/entity/EntitySpawnEvent;", "onVillagerCareerChange", "Lorg/bukkit/event/entity/VillagerCareerChangeEvent;", "onVillagerAcquireTrade", "Lorg/bukkit/event/entity/VillagerAcquireTradeEvent;", "generateNaturalTrades", "villager", "Lorg/bukkit/entity/Villager;", "profession", "Lorg/bukkit/entity/Villager$Profession;", "VillagerProfession"})
public final class VillagerListener
implements Listener {
    @NotNull
    private final JavaPlugin plugin;

    public VillagerListener(@NotNull JavaPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public final void onVillagerSpawn(@NotNull EntitySpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        Entity entity2 = entity;
        if (entity2 instanceof Villager && entity2.hasMetadata("custom_profession")) {
            String string = ((MetadataValue)entity2.getMetadata("custom_profession").get(0)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String professionName = string;
            Villager.Profession profession = Villager.Profession.valueOf((String)professionName);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> VillagerListener.onVillagerSpawn$lambda$0(entity2, profession, this), 5L);
        }
    }

    @EventHandler
    public final void onVillagerCareerChange(@NotNull VillagerCareerChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Villager villager = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)villager, (String)"getEntity(...)");
        Villager villager2 = villager;
        if (villager2.hasMetadata("custom_profession")) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public final void onVillagerAcquireTrade(@NotNull VillagerAcquireTradeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AbstractVillager abstractVillager = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)abstractVillager, (String)"getEntity(...)");
        AbstractVillager villager = abstractVillager;
        if (villager.hasMetadata("custom_profession")) {
            // empty if block
        }
    }

    private final void generateNaturalTrades(Villager villager, Villager.Profession profession) {
        villager.setRecipes((List)new ArrayList());
        VanillaTradeGenerator tradeGenerator = new VanillaTradeGenerator();
        int tradeCount = new Random().nextInt(3) + 1;
        List<MerchantRecipe> trades = tradeGenerator.generateTrades(profession, tradeCount);
        villager.setRecipes(trades);
    }

    private static final void onVillagerSpawn$lambda$0(Entity $entity, Villager.Profession $profession, VillagerListener this$0) {
        if (((Villager)$entity).isValid() && !((Villager)$entity).isDead()) {
            ((Villager)$entity).setProfession($profession);
            this$0.generateNaturalTrades((Villager)$entity, $profession);
        }
    }
}

