/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination;

import codechicken.lib.colour.EnumColour;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.tile.IllumarLampBlockEntity;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.registries.DeferredRegister;

public enum BlockLightType {
    ILLUMAR_LAMP("illumar_lamp", "Illumar Lamp", IllumarLampBlock::new, IllumarLampBlockEntity::new);

    private final String unlocalName;
    private final String localName;
    private final BiFunction<Integer, Boolean, Block> blockFactory;
    private final BlockLightBlockEntityFactory tileFactory;
    private final ArrayList<Supplier<Block>> blockSupplier = new ArrayList();
    private final ArrayList<Supplier<Block>> invertedBlockSupplier = new ArrayList();
    private final ArrayList<Supplier<Item>> itemBlockSupplier = new ArrayList();
    private final ArrayList<Supplier<Item>> invertedItemBlockSupplier = new ArrayList();
    private final ArrayList<Supplier<BlockEntityType<?>>> tileEntityTypeSupplier = new ArrayList();
    private final ArrayList<Supplier<BlockEntityType<?>>> invertedTileEntityTypeSupplier = new ArrayList();

    private BlockLightType(String unlocalName, String localName, BiFunction<Integer, Boolean, Block> blockFactory, BlockLightBlockEntityFactory tileFactory) {
        this.unlocalName = unlocalName;
        this.localName = localName;
        this.blockFactory = blockFactory;
        this.tileFactory = tileFactory;
    }

    public void registerBlocks(DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<BlockEntityType<?>> tileRegistry) {
        int colorFinal;
        int color;
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String registryID = this.getRegistryID(color, false);
            this.blockSupplier.add(color, (Supplier<Block>)blockRegistry.register(registryID, () -> this.blockFactory.apply(colorFinal, false)));
            this.itemBlockSupplier.add(color, (Supplier<Item>)itemRegistry.register(registryID, () -> new BlockItem(this.getBlock(colorFinal, false), new Item.Properties())));
            this.tileEntityTypeSupplier.add(color, (Supplier<BlockEntityType<?>>)tileRegistry.register(registryID, () -> BlockEntityType.Builder.of((pos, state) -> this.tileFactory.create(colorFinal, false, pos, state), (Block[])new Block[]{this.getBlock(colorFinal, false)}).build(null)));
        }
        for (color = 0; color < 16; ++color) {
            colorFinal = color;
            String invertedRegistryID = this.getRegistryID(color, true);
            this.invertedBlockSupplier.add(color, (Supplier<Block>)blockRegistry.register(invertedRegistryID, () -> this.blockFactory.apply(colorFinal, true)));
            this.invertedItemBlockSupplier.add(color, (Supplier<Item>)itemRegistry.register(invertedRegistryID, () -> new BlockItem(this.getBlock(colorFinal, true), new Item.Properties())));
            this.invertedTileEntityTypeSupplier.add(color, (Supplier<BlockEntityType<?>>)tileRegistry.register(invertedRegistryID, () -> BlockEntityType.Builder.of((pos, state) -> this.tileFactory.create(colorFinal, true, pos, state), (Block[])new Block[]{this.getBlock(colorFinal, true)}).build(null)));
        }
    }

    public Block getBlock(int color, boolean inverted) {
        return inverted ? this.invertedBlockSupplier.get(color).get() : this.blockSupplier.get(color).get();
    }

    public Iterable<Block> allColors(boolean inverted) {
        return FastStream.of(inverted ? this.invertedBlockSupplier : this.blockSupplier).map(Supplier::get);
    }

    public BlockEntityType<?> getTileEntityType(int color, boolean inverted) {
        return inverted ? this.invertedTileEntityTypeSupplier.get(color).get() : this.tileEntityTypeSupplier.get(color).get();
    }

    public String getLocalBaseName() {
        return this.localName;
    }

    public String getRegistryID(int color, boolean inverted) {
        return EnumColour.values()[color].getSerializedName().toLowerCase() + (inverted ? "_inverted" : "") + "_" + this.unlocalName;
    }

    @FunctionalInterface
    private static interface BlockLightBlockEntityFactory {
        public BlockEntity create(int var1, boolean var2, BlockPos var3, BlockState var4);
    }
}

