/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.block;

import java.util.function.ToIntFunction;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import mrtjp.projectred.illumination.tile.IllumarSmartLampBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class IllumarSmartLampBlock
extends ProjectRedBlock
implements EntityBlock {
    public static final IntegerProperty LEVEL = LightBlock.LEVEL;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = LightBlock.LIGHT_EMISSION;

    public IllumarSmartLampBlock() {
        super(BlockBehaviour.Properties.of().mapColor(state -> (Integer)state.getValue((Property)LEVEL) > 0 ? MapColor.TERRACOTTA_WHITE : MapColor.COLOR_GRAY).sound(SoundType.GLASS).strength(0.5f).lightLevel(LIGHT_EMISSION));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LEVEL}).add(new Property[]{ProjectRedBlock.SIDE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        int s = pContext.getClickedFace().ordinal() ^ 1;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LEVEL, (Comparable)Integer.valueOf(0))).setValue((Property)SIDE, (Comparable)Integer.valueOf(s));
    }

    protected BlockEntityType<?> getBlockEntityType() {
        return IlluminationBlocks.ILLUMAR_SMART_LAMP_BLOCK_ENTITY.get();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new IllumarSmartLampBlockEntity(pPos, pState);
    }
}

