/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.client;

import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.model.bakedmodels.WrappedItemModel;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.core.client.HaloRenderer;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class IllumarLampItemRenderer
extends WrappedItemModel
implements IItemRenderer {
    private static final Cuboid6 BLOCK_BOUNDS = Cuboid6.full.copy().expand(-0.02);
    private static final Cuboid6 GLOW_BOUNDS = Cuboid6.full.copy().expand(0.02);
    private static final RandomSource random = RandomSource.create();

    public IllumarLampItemRenderer(BakedModel wrapped) {
        super(wrapped);
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        if (!(block instanceof IllumarLampBlock)) {
            return;
        }
        IllumarLampBlock block2 = (IllumarLampBlock)block;
        if (!block2.isInverted()) {
            this.renderWrapped(stack, mStack, getter, packedLight, packedOverlay, false);
            return;
        }
        TextureAtlasSprite icon = ((BakedQuad)this.wrapped.getQuads(null, Direction.UP, random).get(0)).getSprite();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(RenderType.cutout(), getter, mStack);
        ccrs.setPipeline(new IVertexOperation[]{new IconTransformation(icon)});
        BlockRenderer.renderCuboid((CCRenderState)ccrs, (Cuboid6)BLOCK_BOUNDS, (int)0);
        HaloRenderer.renderInventoryHalo((CCRenderState)ccrs, (PoseStack)mStack, (MultiBufferSource)getter, (Cuboid6)GLOW_BOUNDS, (Vector3)Vector3.ZERO, (int)block2.getColor());
        HaloRenderer.addItemRendererBloom((ItemDisplayContext)transformType, (PoseStack)mStack, (Vector3)Vector3.ZERO, (Cuboid6)GLOW_BOUNDS, (int)block2.getColor());
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public boolean useAmbientOcclusion() {
        return true;
    }

    public boolean isGui3d() {
        return true;
    }

    public boolean usesBlockLight() {
        return true;
    }
}

