/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.data;

import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.block.IllumarLampBlock;
import mrtjp.projectred.illumination.block.IllumarSmartLampBlock;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class IlluminationBlockStateModelProvider
extends BlockStateProvider {
    private static final int[][] DEVICE_SIDED_ROTATIONS = new int[][]{{0, 0}, {2, 2}, {1, 2}, {1, 0}, {1, 1}, {1, 3}};

    public IlluminationBlockStateModelProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "projectred_illumination", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (BlockLightType lampType : BlockLightType.values()) {
            for (int color = 0; color < 16; ++color) {
                this.addIllumarLampVariants(lampType.getBlock(color, true));
                this.addIllumarLampVariants(lampType.getBlock(color, false));
            }
        }
        this.addSidedBlockVariants(IlluminationBlocks.ILLUMAR_SMART_LAMP.get(), (ModelFile)this.createSmartLampModel(IlluminationBlocks.ILLUMAR_SMART_LAMP.get(), false), (ModelFile)this.createSmartLampModel(IlluminationBlocks.ILLUMAR_SMART_LAMP.get(), true));
    }

    private void addIllumarLampVariants(Block block) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)this.createLampModel(block, (Boolean)state.getValue((Property)IllumarLampBlock.LIT))).build());
    }

    private BlockModelBuilder createLampModel(Block block, boolean lit) {
        String textureName = BlockLightType.ILLUMAR_LAMP.getRegistryID(((IllumarLampBlock)block).getColor(), false) + (lit ? "_on" : "");
        return (BlockModelBuilder)this.models().cubeAll(textureName, this.modLoc("block/" + textureName));
    }

    private void addSidedBlockVariants(Block block, ModelFile offModel, ModelFile onModel) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int s = (Integer)state.getValue((Property)ProjectRedBlock.SIDE);
            boolean lit = (Integer)state.getValue((Property)IllumarSmartLampBlock.LEVEL) > 0;
            return ConfiguredModel.builder().modelFile(lit ? onModel : offModel).rotationX(DEVICE_SIDED_ROTATIONS[s][0] * 90).rotationY(DEVICE_SIDED_ROTATIONS[s][1] * 90).build();
        });
    }

    private BlockModelBuilder createSmartLampModel(Block block, boolean lit) {
        String texture = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        String litKey = lit ? "_on" : "";
        String modelName = texture + litKey;
        return (BlockModelBuilder)this.models().cubeBottomTop(modelName, this.modLoc("block/" + texture + "_side" + litKey), this.modLoc("block/" + texture + "_bottom"), this.modLoc("block/" + texture + "_top" + litKey));
    }
}

