/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.illumination.data;

import mrtjp.projectred.illumination.BlockLightType;
import mrtjp.projectred.illumination.MultipartLightType;
import mrtjp.projectred.illumination.init.IlluminationBlocks;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class IlluminationLanguageProvider
extends LanguageProvider {
    private static final String[] LOCAL_COLORS = new String[]{"White", "Orange", "Magenta", "Light Blue", "Yellow", "Lime", "Pink", "Gray", "Light Gray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};

    public IlluminationLanguageProvider(PackOutput output) {
        super(output, "projectred_illumination", "en_us");
    }

    protected void addTranslations() {
        int color;
        this.add("itemGroup.projectred_illumination", "Project Red: Illumination");
        for (BlockLightType blockLightType : BlockLightType.values()) {
            for (color = 0; color < 16; ++color) {
                this.add(blockLightType.getBlock(color, false), IlluminationLanguageProvider.createLocalizedLightName(color, false, blockLightType.getLocalBaseName()));
                this.add(blockLightType.getBlock(color, true), IlluminationLanguageProvider.createLocalizedLightName(color, true, blockLightType.getLocalBaseName()));
            }
        }
        this.addBlock(IlluminationBlocks.ILLUMAR_SMART_LAMP, "Illumar Smart Lamp");
        for (Enum enum_ : MultipartLightType.values()) {
            for (color = 0; color < 16; ++color) {
                this.add(((MultipartLightType)enum_).getItem(color, false), IlluminationLanguageProvider.createLocalizedLightName(color, false, ((MultipartLightType)enum_).getLocalBaseName()));
                this.add(((MultipartLightType)enum_).getItem(color, true), IlluminationLanguageProvider.createLocalizedLightName(color, true, ((MultipartLightType)enum_).getLocalBaseName()));
            }
        }
    }

    public static String createLocalizedLightName(int color, boolean inverted, String lightName) {
        return LOCAL_COLORS[color] + (inverted ? " Inverted " : " ") + lightName;
    }
}

