/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import com.minelittlepony.common.util.io.PathMonitor;
import com.minelittlepony.common.util.settings.Grouping;
import com.minelittlepony.common.util.settings.HeirarchicalJsonConfigAdapter;
import com.minelittlepony.common.util.settings.LegacyJsonConfigAdapter;
import com.minelittlepony.common.util.settings.MapGrouping;
import com.minelittlepony.common.util.settings.Setting;
import com.minelittlepony.common.util.settings.Value;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class Config
implements Iterable<Grouping> {
    @Deprecated
    public static final Adapter FLATTENED_JSON_ADAPTER = LegacyJsonConfigAdapter.DEFAULT;
    public static final Adapter HEIRARCHICAL_JSON_ADAPTER = HeirarchicalJsonConfigAdapter.DEFAULT;
    private final Map<String, Grouping> categories = new HashMap<String, Grouping>();
    private final Adapter adapter;
    private final Path path;
    private final List<Consumer<Config>> listeners = new ArrayList<Consumer<Config>>();
    private final PathMonitor monitor = new PathMonitor(event -> {
        switch (event) {
            case MODIFY: {
                this.load();
                break;
            }
            case DELETE: {
                this.categories.forEach((? super K name, ? super V category) -> category.entries().forEach(setting -> setting.set(setting.getDefault())));
            }
        }
        this.listeners.forEach(listener -> listener.accept(this));
    });

    protected Config(Adapter adapter, Path path) {
        this.adapter = adapter;
        this.path = path;
        this.monitor.set(path, adapter.getAlternatives(path).toList());
    }

    public void onChangedExternally(Consumer<Config> listener) {
        this.listeners.add(listener);
    }

    protected <T> Setting<T> value(String key, T def) {
        return this.value("root", key, def);
    }

    protected <T> Setting<T> value(String category, String key, T def) {
        return this.value(category, key, Setting.Type.of(() -> def));
    }

    protected <T, C extends Collection<T>> Setting<C> value(String category, String key, Supplier<C> def, Class<T> elementType) {
        return this.value(category, key, Setting.Type.of(def, elementType));
    }

    protected <K, V, C extends Map<K, V>> Setting<C> value(String category, String key, Supplier<C> def, Class<K> keyType, Class<V> valueType) {
        return this.value(category, key, Setting.Type.of(def, keyType, valueType));
    }

    protected <T> Setting<T> value(String category, String key, Setting.Type<T> type) {
        return ((MapGrouping)this.categories.computeIfAbsent(category, c -> new MapGrouping(new HashMap(), new ArrayList<String>()))).map().computeIfAbsent(key.toLowerCase(), k -> new Value(key, type));
    }

    @Deprecated
    public Iterable<Setting<?>> getByCategory(String category) {
        return this.categories.get(category).entries();
    }

    @Deprecated
    public <T> Setting<T> get(String key) {
        return this.categories.values().stream().flatMap(c -> c.stream()).filter(entry -> entry.name().equalsIgnoreCase(key)).findFirst().orElse(null);
    }

    @Deprecated
    public boolean containsKey(String key) {
        return this.get(key) != null;
    }

    public Iterable<String> categoryNames() {
        return this.categories.keySet();
    }

    public Grouping getCategory(String categoryName) {
        return this.categories.getOrDefault(categoryName, Grouping.EMPTY);
    }

    public Optional<Grouping> getCategoryOrEmpty(String categoryName) {
        return this.categories.containsKey(categoryName) ? Optional.of(this.categories.get(categoryName)) : Optional.empty();
    }

    public Stream<Map.Entry<String, Grouping>> categories() {
        return this.categories.entrySet().stream();
    }

    @Override
    public Iterator<Grouping> iterator() {
        return this.categories.values().iterator();
    }

    public void save() {
        this.monitor.wrap(() -> this.adapter.save(this, this.path));
    }

    public void load() {
        this.monitor.wrap(() -> this.adapter.load(this, this.path));
    }

    public static interface Adapter {
        default public Stream<Path> getAlternatives(Path file) {
            return Stream.of(file);
        }

        public void load(Config var1, Path var2);

        public void save(Config var1, Path var2);
    }
}

