/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_156;
import org.jetbrains.annotations.Nullable;

public class Json5Writer
extends JsonWriter {
    static boolean LOAD_FAIL;
    static final BiConsumer<JsonWriter, Integer> INVOKE_REPLACE_TOP;
    static final Function<JsonWriter, Integer> INVOKE_PEEK;
    static final int EMPTY_ARRAY = 1;
    static final int NONEMPTY_ARRAY = 2;
    static final int EMPTY_OBJECT = 3;
    static final int NONEMPTY_OBJECT = 5;
    static final String INDENT = "  ";
    private final Writer out;
    private int depth;
    @Nullable
    private String deferredName;
    private boolean firstMember = true;
    private final List<String> deferredComments = new ArrayList<String>();

    public Json5Writer(Writer out, Gson gson) {
        super(out);
        this.out = out;
        this.setIndent(INDENT);
        this.setHtmlSafe(gson.htmlSafe());
        this.setSerializeNulls(gson.serializeNulls());
        this.setLenient(true);
    }

    public Json5Writer comment(String comment) {
        this.deferredComments.add(comment);
        return this;
    }

    public Json5Writer beginArray() throws IOException {
        this.beforeValue();
        super.beginArray();
        this.firstMember = true;
        ++this.depth;
        return this;
    }

    public Json5Writer endArray() throws IOException {
        super.endArray();
        this.firstMember = false;
        --this.depth;
        return this;
    }

    public Json5Writer beginObject() throws IOException {
        this.beforeValue();
        super.beginObject();
        this.firstMember = true;
        ++this.depth;
        return this;
    }

    public Json5Writer endObject() throws IOException {
        super.endObject();
        this.firstMember = false;
        --this.depth;
        return this;
    }

    public Json5Writer name(String name) throws IOException {
        this.deferredName = name;
        super.name(name);
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    public Json5Writer jsonValue(String value) throws IOException {
        this.beforeValue();
        super.jsonValue(value);
        return this;
    }

    public Json5Writer nullValue() throws IOException {
        this.beforeValue();
        super.nullValue();
        return this;
    }

    public Json5Writer value(boolean value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    public Json5Writer value(Boolean value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    public Json5Writer value(float value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    public Json5Writer value(double value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    public Json5Writer value(long value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    public Json5Writer value(Number value) throws IOException {
        this.beforeValue();
        super.value(value);
        return this;
    }

    protected void newline() throws IOException {
        this.out.write(10);
        for (int i = 0; i < this.depth; ++i) {
            this.out.write(INDENT);
        }
    }

    protected void beforeValue() throws IOException {
        if (this.deferredName != null) {
            this.deferredName = null;
            if (!this.deferredComments.isEmpty()) {
                int top;
                if (!(LOAD_FAIL || (top = INVOKE_PEEK.apply(this).intValue()) != 5 && top != 2)) {
                    INVOKE_REPLACE_TOP.accept(this, top == 5 ? 3 : 1);
                }
                if (!this.firstMember) {
                    this.out.write(44);
                }
                this.newline();
                this.out.write("/*");
                for (String comment : this.deferredComments) {
                    this.newline();
                    this.out.write(" * ");
                    this.out.write(comment);
                }
                this.newline();
                this.out.write(" */");
                this.deferredComments.clear();
            }
        }
        this.firstMember = false;
    }

    static {
        INVOKE_REPLACE_TOP = (BiConsumer)class_156.method_656(() -> {
            try {
                MethodHandle handle = MethodHandles.privateLookupIn(JsonWriter.class, MethodHandles.lookup()).findSpecial(JsonWriter.class, "replaceTop", MethodType.methodType(Void.TYPE, Integer.TYPE), JsonWriter.class);
                return (self, top) -> {
                    try {
                        handle.invoke((JsonWriter)self, (Integer)top);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                };
            }
            catch (Throwable e) {
                LOAD_FAIL = true;
                return (self, top) -> {};
            }
        });
        INVOKE_PEEK = (Function)class_156.method_656(() -> {
            try {
                MethodHandle handle = MethodHandles.privateLookupIn(JsonWriter.class, MethodHandles.lookup()).findSpecial(JsonWriter.class, "peek", MethodType.methodType(Integer.TYPE), JsonWriter.class);
                return self -> {
                    try {
                        return handle.invoke((JsonWriter)self);
                    }
                    catch (Throwable throwable) {
                        return -1;
                    }
                };
            }
            catch (Throwable e) {
                LOAD_FAIL = true;
                return self -> -1;
            }
        });
    }
}

