/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.element.AbstractSlider;
import java.util.Objects;
import java.util.function.Supplier;

public class Slider
extends AbstractSlider<Float> {
    private final float valueRange;

    public Slider(int x, int y, float min, float max, Supplier<? extends Number> value) {
        this(x, y, min, max, Objects.requireNonNull(value.get(), "value was null").floatValue());
    }

    public Slider(int x, int y, float min, float max, float value) {
        super(x, y, min, max, Float.valueOf(value));
        this.valueRange = max - min;
    }

    @Override
    protected float valueToFloat(Float value) {
        return value.floatValue();
    }

    @Override
    protected Float floatToValue(float value) {
        return Float.valueOf(value);
    }

    @Override
    protected Float nextValue(Float value, int steps) {
        float valuePerPixel = this.valueRange / (float)(this.method_25368() - 8);
        return Float.valueOf(value.floatValue() + valuePerPixel * 8.0f * (float)steps);
    }
}

