/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.packing;

import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.packing.IPacker;

public class GridPacker
implements IPacker {
    private final Bounds screen = new Bounds(0, 0, 0, 0);
    private final Bounds bounds = new Bounds(0, 0, 0, 0);
    private int itemSpacing;
    private int alignmentOffset;
    private int xOffset;
    private int yOffset;

    public GridPacker setOffset(int x, int y) {
        this.xOffset = x;
        this.yOffset = y;
        return this;
    }

    public GridPacker setListWidth(int width) {
        this.screen.width = width;
        return this;
    }

    public GridPacker setItemSpacing(int spacing) {
        this.itemSpacing = spacing;
        return this;
    }

    public GridPacker setItemWidth(int width) {
        this.bounds.width = width;
        return this;
    }

    public GridPacker setItemHeight(int height) {
        this.bounds.height = height;
        return this;
    }

    @Override
    public void start() {
        this.alignmentOffset = this.computeAlignmentOffset();
        this.bounds.top = this.yOffset;
        this.bounds.left = -(this.bounds.width + this.itemSpacing) + this.alignmentOffset + this.xOffset;
    }

    @Override
    public Bounds next() {
        this.bounds.left += this.bounds.width + this.itemSpacing;
        if (this.bounds.left + this.bounds.width - this.alignmentOffset >= this.screen.width - 30) {
            this.bounds.left = this.alignmentOffset;
            this.bounds.top += this.bounds.height + this.itemSpacing;
        }
        return this.bounds;
    }

    protected int computeAlignmentOffset() {
        float maxWidth = this.screen.width - 30;
        float colWidth = this.bounds.width + this.itemSpacing;
        float maxCols = (float)Math.floor(maxWidth / colWidth);
        float computedWidth = (float)this.bounds.width * maxCols + (float)this.itemSpacing * (maxCols - 1.0f);
        return (int)Math.floor(maxWidth / 2.0f - computedWidth / 2.0f);
    }
}

