/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.settings.CodecTypeAdapter;
import com.minelittlepony.common.util.settings.Config;
import com.minelittlepony.common.util.settings.FileUtils;
import com.minelittlepony.common.util.settings.Grouping;
import com.minelittlepony.common.util.settings.Json5Writer;
import com.minelittlepony.common.util.settings.Setting;
import com.minelittlepony.common.util.settings.SettingSerializer;
import com.minelittlepony.common.util.settings.ToStringAdapter;
import com.mojang.util.UUIDTypeAdapter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_2096;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeirarchicalJsonConfigAdapter
implements Config.Adapter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String[] JSON_FORMATS = new String[]{"json5", "json"};
    private final Gson gson;
    public static final HeirarchicalJsonConfigAdapter DEFAULT = new HeirarchicalJsonConfigAdapter(new GsonBuilder());

    public HeirarchicalJsonConfigAdapter(GsonBuilder builder) {
        this.gson = builder.setStrictness(Strictness.LENIENT).setPrettyPrinting().registerTypeHierarchyAdapter(Path.class, new ToStringAdapter<Path>(x$0 -> Paths.get(x$0, new String[0]))).registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeHierarchyAdapter(Setting.class, (Object)new SettingSerializer()).registerTypeAdapter(class_2960.class, new ToStringAdapter<class_2960>(class_2960::method_60654)).registerTypeAdapter(class_2096.class_2100.class, new CodecTypeAdapter(class_2096.class_2100.field_45763)).registerTypeAdapter(class_2096.class_2099.class, new CodecTypeAdapter(class_2096.class_2099.field_45762)).create();
    }

    @Override
    public Stream<Path> getAlternatives(Path file) {
        return FileUtils.getAlternatives(file, JSON_FORMATS);
    }

    @Override
    public void save(Config config, Path file) {
        try (Json5Writer writer = new Json5Writer(Files.newBufferedWriter(this.correctExtension(file).orElse(FileUtils.changeExtension(file, "json5")), new OpenOption[0]), this.gson);){
            writer.beginObject();
            for (String category : config.categoryNames()) {
                Grouping cat = config.getCategory(category);
                for (String comment : cat.getComments()) {
                    writer.comment(comment);
                }
                writer.name(category);
                writer.beginObject();
                for (Map.Entry setting : cat) {
                    for (String comment : ((Setting)setting.getValue()).getComments()) {
                        writer.comment(comment);
                    }
                    writer.name(((Setting)setting.getValue()).name());
                    Streams.write((JsonElement)((Setting)setting.getValue()).getType().write((Setting)setting.getValue(), this.gson), (JsonWriter)writer);
                }
                writer.endObject();
            }
            writer.endObject();
        }
        catch (Throwable e) {
            LOGGER.warn("Error whilst saving Json config", e);
        }
    }

    @Override
    public void load(Config config, Path file) {
        try {
            this.correctExtension(file).ifPresent(f -> {
                try (JsonReader reader = this.gson.newJsonReader((Reader)Files.newBufferedReader(f));){
                    Streams.parse((JsonReader)reader).getAsJsonObject().entrySet().forEach(entry -> config.getCategoryOrEmpty((String)entry.getKey()).ifPresent(category -> ((JsonElement)entry.getValue()).getAsJsonObject().entrySet().forEach(tuple -> category.getOrEmpty(((String)tuple.getKey()).toLowerCase()).ifPresent(setting -> setting.set(setting.getType().read(setting, (JsonElement)tuple.getValue(), this.gson))))));
                }
                catch (Throwable e) {
                    LOGGER.warn("Erorr whilst loading json config", e);
                }
            });
        }
        finally {
            this.save(config, file);
        }
    }

    private Optional<Path> correctExtension(Path file) {
        return this.getAlternatives(file).filter(Files::isReadable).findFirst();
    }
}

