/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IViewRoot;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.dimension.Padding;
import com.minelittlepony.common.client.gui.element.Scrollbar;
import com.minelittlepony.common.client.gui.scrollable.ScrollOrientation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiConsumer;
import net.minecraft.class_1041;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import org.joml.Matrix3x2fStack;

public class ScrollContainer
extends GameGui {
    public final Scrollbar verticalScrollbar = new Scrollbar((IViewRoot)((Object)this), ScrollOrientation.VERTICAL);
    public final Scrollbar horizontalScrollbar = new Scrollbar((IViewRoot)((Object)this), ScrollOrientation.HORIZONTAL);
    public final Padding margin = new Padding(0, 0, 0, 0);
    public int backgroundColor = 0x66000000;
    public int decorationColor = -301989888;
    private final Deque<Runnable> delayedCalls = new ArrayDeque<Runnable>();

    public ScrollContainer() {
        super(class_5244.field_39003);
        this.horizontalScrollbar.layoutToEnd = true;
        this.method_25423(class_310.method_1551(), 0, 0);
    }

    public void method_25426() {
        this.init(() -> {});
    }

    public void init(Runnable contentInitializer) {
        this.method_37067();
        this.field_22789 = this.getBounds().width = this.field_22787.method_22683().method_4486() - this.margin.left - this.margin.right;
        this.field_22790 = this.getBounds().height = this.field_22787.method_22683().method_4502() - this.margin.top - this.margin.bottom;
        this.getBounds().top = this.margin.top;
        this.getBounds().left = this.margin.left;
        contentInitializer.run();
        this.verticalScrollbar.reposition();
        this.horizontalScrollbar.reposition();
        this.getChildElements().add(this.verticalScrollbar);
        this.getChildElements().add(this.horizontalScrollbar);
    }

    @Override
    public final void method_25394(class_332 context, int mouseX, int mouseY, float tickDelta) {
        this.getBounds().scissor(context);
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        this.getBounds().translate(matrices);
        this.drawBackground(context, mouseX, mouseY, tickDelta);
        Padding padding = this.getContentPadding();
        matrices.pushMatrix();
        matrices.translate((float)(this.getScrollX() + padding.left), (float)(this.getScrollY() + padding.top));
        this.renderContents(context, mouseX < this.margin.left || mouseX > this.margin.left + this.getBounds().width ? -1000 : mouseX + this.getMouseXOffset(), mouseY < this.margin.top || mouseY > this.margin.top + this.getBounds().height ? -1000 : mouseY + this.getMouseYOffset(), tickDelta);
        matrices.popMatrix();
        this.verticalScrollbar.method_25394(context, mouseX - this.margin.left, mouseY - this.margin.top, tickDelta);
        this.horizontalScrollbar.method_25394(context, mouseX - this.margin.left, mouseY - this.margin.top, tickDelta);
        this.drawDecorations(context, mouseX, mouseY, tickDelta);
        matrices.popMatrix();
        context.method_44380();
        this.drawOverlays(context, mouseX, mouseY, tickDelta);
    }

    protected void renderContents(class_332 context, int mouseX, int mouseY, float tickDelta) {
        super.method_25394(context, mouseX, mouseY, tickDelta);
    }

    @Deprecated
    public final void method_25420(class_332 context, int mouseX, int mouseY, float tickDelta) {
    }

    protected void drawBackground(class_332 context, int mouseX, int mouseY, float tickDelta) {
        context.method_25294(0, 0, this.field_22789, this.field_22790, this.backgroundColor);
    }

    protected void drawDecorations(class_332 context, int mouseX, int mouseY, float tickDelta) {
        context.method_25296(0, -3, this.field_22789, 5, this.decorationColor, 0);
        context.method_25296(0, this.field_22790 - 6, this.field_22789, this.field_22790 + 3, 0, this.decorationColor);
    }

    protected void drawOverlays(class_332 context, int mouseX, int mouseY, float tickDelta) {
        Runnable task;
        class_1041 window = class_310.method_1551().method_22683();
        context.method_44379(0, 0, window.method_4486(), window.method_4502());
        while ((task = this.delayedCalls.poll()) != null) {
            task.run();
        }
        context.method_44380();
    }

    public void method_16014(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            super.method_25403(new class_11909(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), new class_11910(0, 0)), 0.0, 0.0);
        }
    }

    public int getMouseYOffset() {
        return -this.getBounds().top - this.getScrollY() - this.getContentPadding().top;
    }

    public int getMouseXOffset() {
        return -this.getBounds().left - this.getScrollX() - this.getContentPadding().left;
    }

    public int getScrollX() {
        return -this.horizontalScrollbar.getScrubber().getPosition();
    }

    public int getScrollY() {
        return -this.verticalScrollbar.getScrubber().getPosition();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        return this.method_25405(click.comp_4798(), click.comp_4799()) && super.method_25402(this.getContentClick(click), doubled);
    }

    protected class_11909 getContentClick(class_11909 click) {
        return new class_11909(click.comp_4798() + (double)this.getMouseXOffset(), click.comp_4799() + (double)this.getMouseYOffset(), click.comp_4800());
    }

    public boolean method_25406(class_11909 click) {
        return this.method_25405(click.comp_4798(), click.comp_4799()) && super.method_25406(this.getContentClick(click));
    }

    public boolean method_25403(class_11909 click, double differX, double differY) {
        return super.method_25403(this.getContentClick(click), differX, differY);
    }

    public boolean method_25401(double mouseX, double mouseY, double xScroll, double yScroll) {
        this.verticalScrollbar.scrollBy((float)Math.signum(yScroll) * 12.0f);
        this.horizontalScrollbar.scrollBy((float)Math.signum(xScroll) * 12.0f);
        return this.method_25405(mouseX, mouseY) && super.method_25401(mouseX + (double)this.getMouseXOffset(), mouseY + (double)this.getMouseYOffset(), xScroll, yScroll);
    }

    protected void renderOutside(class_332 context, int mouseX, int mouseY, BiConsumer<Integer, Integer> renderCall) {
        this.delayedCalls.add(() -> {
            context.method_51448().pushMatrix();
            renderCall.accept(mouseX - this.getMouseXOffset(), mouseY - this.getMouseYOffset());
            context.method_51448().popMatrix();
        });
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.getBounds().contains(mouseX, mouseY);
    }

    public void setBounds(Bounds bounds) {
        this.margin.top = bounds.top;
        this.margin.left = bounds.left;
    }

    @Override
    protected boolean isUnFixedPosition(Bounds bound) {
        return bound != this.verticalScrollbar.getBounds() && bound != this.horizontalScrollbar.getBounds();
    }
}

