/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.element.Button;
import java.util.function.Function;
import net.minecraft.class_10799;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8015;
import net.minecraft.class_8666;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSlider<T>
extends Button
implements IField<T, AbstractSlider<T>> {
    private static final class_2960 TEXTURE = class_2960.method_60656((String)"widget/slider");
    private static final class_2960 HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"widget/slider_highlighted");
    private static final class_2960 HANDLE_TEXTURE = class_2960.method_60656((String)"widget/slider_handle");
    private static final class_2960 HANDLE_HIGHLIGHTED_TEXTURE = class_2960.method_60656((String)"widget/slider_handle_highlighted");
    protected static final class_8666 TEXTURES = new class_8666(TEXTURE, TEXTURE, HIGHLIGHTED_TEXTURE);
    protected static final class_8666 HANDLE_TEXTURES = new class_8666(HANDLE_TEXTURE, HANDLE_TEXTURE, HANDLE_HIGHLIGHTED_TEXTURE);
    public static final int SLIDER_WIDTH = 8;
    public static final int HALF_SLIDER_WIDTH = 4;
    private float min;
    private float max;
    private float value;
    private boolean handleFocused;
    @NotNull
    private IField.IChangeCallback<T> action = IField.IChangeCallback::none;
    @Nullable
    private Function<AbstractSlider<T>, class_2561> textFunc;
    @Nullable
    private Function<AbstractSlider<T>, Tooltip> tooltipFunc;

    public AbstractSlider(int x, int y, float min, float max, T value) {
        super(x, y);
        this.min = min;
        this.max = max;
        this.value = AbstractSlider.convertFromRange(this.valueToFloat(value), min, max);
    }

    protected abstract float valueToFloat(T var1);

    protected abstract T floatToValue(float var1);

    protected abstract T nextValue(T var1, int var2);

    @Override
    public AbstractSlider<T> onChange(@NotNull IField.IChangeCallback<T> action) {
        this.action = action;
        return this;
    }

    public AbstractSlider<T> setTextFormat(@NotNull Function<AbstractSlider<T>, class_2561> formatter) {
        this.textFunc = formatter;
        this.getStyle().setText(formatter.apply(this));
        return this;
    }

    public AbstractSlider<T> setTooltipFormat(@NotNull Function<AbstractSlider<T>, Tooltip> formatter) {
        this.tooltipFunc = formatter;
        this.getStyle().setTooltip(formatter.apply(this));
        return this;
    }

    @Override
    public AbstractSlider<T> setValue(T value) {
        this.setClampedValue(AbstractSlider.convertFromRange(this.valueToFloat(value), this.min, this.max));
        return this;
    }

    public boolean method_25404(class_11908 input) {
        if (this.field_22763 && this.field_22764 && (input.method_74232() || input.method_74233())) {
            this.method_25354(class_310.method_1551().method_1483());
            this.setClampedValue(this.valueToFloat(this.nextValue(this.floatToValue(this.value), input.method_74232() ? -1 : 1)));
            this.method_25306((class_11907)input);
            return true;
        }
        return false;
    }

    protected void setClampedValue(float value) {
        if ((value = class_3532.method_15363((float)value, (float)0.0f, (float)1.0f)) != this.value) {
            float initial = this.value;
            this.value = value;
            this.value = AbstractSlider.convertFromRange(this.valueToFloat(this.action.perform(this.getValue())), this.min, this.max);
            if (this.value != initial) {
                if (this.textFunc != null) {
                    this.getStyle().setText(this.textFunc.apply(this));
                }
                if (this.tooltipFunc != null) {
                    this.getStyle().setTooltip(this.tooltipFunc.apply(this));
                }
            }
        }
    }

    private void onChange(double mouseX) {
        this.setClampedValue((float)(mouseX - (double)(this.method_46426() + 4)) / (float)(this.method_25368() - 8));
    }

    @Override
    public T getValue() {
        return this.floatToValue(AbstractSlider.convertToRange(this.value, this.min, this.max));
    }

    public void method_25348(class_11909 click, boolean doubled) {
        super.method_25348(click, doubled);
        this.onChange(click.comp_4798());
    }

    protected void method_25349(class_11909 click, double mouseDX, double mouseDY) {
        this.onChange(click.comp_4798());
    }

    public void method_25365(boolean focused) {
        class_8015 guiNavigationType;
        super.method_25365(focused);
        this.handleFocused = !focused ? false : (this.handleFocused |= (guiNavigationType = class_310.method_1551().method_48186()) == class_8015.field_41778 || guiNavigationType == class_8015.field_41780);
    }

    private int getSliderX() {
        return (int)(this.value * (float)(this.method_25368() - 8));
    }

    @Override
    protected class_11875 getCursor(int mouseX, int mouseY) {
        int sliderX;
        return (mouseX -= this.method_46426()) >= (sliderX = this.getSliderX()) && mouseX <= sliderX + 8 ? class_11876.field_62457 : super.getCursor(mouseX, mouseY);
    }

    @Override
    protected void renderBackground(class_332 context, class_310 mc, int mouseX, int mouseY) {
        context.method_52707(class_10799.field_56883, TEXTURES.method_52729(this.field_22763, this.method_25367() && !this.handleFocused), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), class_9848.method_61317((float)this.field_22765));
        context.method_52707(class_10799.field_56883, HANDLE_TEXTURES.method_52729(this.field_22763, this.method_25367() && this.handleFocused), this.method_46426() + this.getSliderX(), this.method_46427(), 8, this.method_25364(), class_9848.method_61317((float)this.field_22765));
    }

    protected class_5250 method_25360() {
        return class_2561.method_43469((String)"gui.narrate.slider", (Object[])new Object[]{this.method_25369()});
    }

    @Override
    public void method_47399(class_6382 builder) {
        super.method_47399(builder);
        builder.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
        if (this.field_22763) {
            builder.method_37034(class_6381.field_33791, (class_2561)class_2561.method_43471((String)("narration.slider.usage." + (this.method_25370() ? (this.handleFocused ? "focused" : "focused.keyboard_cannot_change_value") : "hovered"))));
        }
    }

    static float convertFromRange(float value, float min, float max) {
        return (class_3532.method_15363((float)value, (float)min, (float)max) - min) / (max - min);
    }

    static float convertToRange(float value, float min, float max) {
        return class_3532.method_15363((float)(min + value * (max - min)), (float)min, (float)max);
    }
}

