/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.element.AbstractSlider;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;

public class EnumSlider<T extends Enum<T>>
extends AbstractSlider<T> {
    private final T[] values;

    public EnumSlider(int x, int y, Supplier<T> value) {
        this(x, y, Objects.requireNonNull((Enum)value.get(), "value was null"));
    }

    public EnumSlider(int x, int y, T value) {
        super(x, y, 0.0f, ((Enum[])value.getClass().getEnumConstants()).length - 1, value);
        this.values = (Enum[])value.getClass().getEnumConstants();
        this.setTextFormat(s -> class_2561.method_30163((String)((Enum)this.getValue()).name()));
    }

    @Override
    protected float valueToFloat(T value) {
        return ((Enum)value).ordinal();
    }

    @Override
    protected T floatToValue(float value) {
        for (value = (float)Math.round(value); value < 0.0f; value += (float)this.values.length) {
        }
        return this.values[(int)value % this.values.length];
    }

    @Override
    protected T nextValue(T value, int steps) {
        int ordinal;
        for (ordinal = ((Enum)value).ordinal() + steps; ordinal < 0; ordinal += this.values.length) {
        }
        return this.values[ordinal % this.values.length];
    }
}

