/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.bind;

import com.yzqdev.mod.jeanmod.bind.Constants;
import com.yzqdev.mod.jeanmod.network.CommandItemMessage;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;

@OnlyIn(value=Dist.CLIENT)
public class CommandItemScreen
extends Screen {
    private static final Component SET_COMMAND_LABEL = Component.translatable((String)"advMode.setCommand");
    private static final Component COMMAND_LABEL = Component.translatable((String)"advMode.command");
    private static final Component PREVIOUS_OUTPUT_LABEL = Component.translatable((String)"advMode.previousOutput");
    protected EditBox commandEdit;
    protected Button doneButton;
    protected Button cancelButton;
    protected CycleButton<Boolean> outputButton;
    CommandSuggestions commandSuggestions;
    private final ItemStack targetItem;

    public CommandItemScreen(ItemStack targetItem) {
        super(GameNarrator.NO_TITLE);
        this.targetItem = targetItem;
    }

    private void applyTextToItem() {
        if (!this.commandEdit.getValue().isEmpty() && !this.targetItem.isEmpty()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CommandItemMessage(this.targetItem, this.commandEdit.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void init() {
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, p_97691_ -> this.onDone()).bounds(this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20).build());
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, p_289627_ -> this.onClose()).bounds(this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20).build());
        this.commandEdit = new EditBox(this.font, this.width / 2 - 150, 50, 300, 20, (Component)Component.translatable((String)"advMode.command")){

            protected MutableComponent createNarrationMessage() {
                return super.createNarrationMessage().append(CommandItemScreen.this.commandSuggestions.getNarrationMessage());
            }
        };
        this.commandEdit.setMaxLength(32500);
        this.commandEdit.setResponder(this::onEdited);
        this.addWidget((GuiEventListener)this.commandEdit);
        this.setInitialFocus((GuiEventListener)this.commandEdit);
        this.commandSuggestions = new CommandSuggestions(this.minecraft, (Screen)this, this.commandEdit, this.font, true, true, 0, 7, false, Integer.MIN_VALUE);
        this.commandSuggestions.setAllowSuggestions(true);
        this.commandSuggestions.updateCommandInfo();
        String cmdText = (String)this.targetItem.get(Constants.commandNbt);
        if (StringUtils.isNotEmpty((CharSequence)cmdText)) {
            this.commandEdit.setValue(cmdText);
        }
    }

    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.commandEdit.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.commandEdit.setValue(s);
        this.commandSuggestions.updateCommandInfo();
    }

    protected void onDone() {
        this.applyTextToItem();
        this.minecraft.setScreen((Screen)null);
    }

    private void onEdited(String p_97689_) {
        this.commandSuggestions.updateCommandInfo();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.commandSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode != 257 && pKeyCode != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        return this.commandSuggestions.mouseClicked(pMouseX, pMouseY, pButton) ? true : super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.drawCenteredString(this.font, SET_COMMAND_LABEL, this.width / 2, 20, 0xFFFFFF);
        pGuiGraphics.drawString(this.font, COMMAND_LABEL, this.width / 2 - 150, 40, 0xA0A0A0);
        this.commandEdit.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.commandSuggestions.render(pGuiGraphics, pMouseX, pMouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
    }
}

