/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.util.MobUtil;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class DamageCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get(CommandBuildContext context) {
        LiteralArgumentBuilder pack = Commands.literal((String)"damage");
        LiteralArgumentBuilder damage = (LiteralArgumentBuilder)Commands.literal((String)"hurt").then(Commands.argument((String)"entity", (ArgumentType)ResourceArgument.resource((CommandBuildContext)context, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(DamageCommand::damageMaid));
        pack.then((ArgumentBuilder)damage);
        return pack;
    }

    private static int damageMaid(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Level level = serverPlayer.level();
        Holder.Reference entity = ResourceArgument.getSummonableEntityType(context, (String)"entity");
        EntityType f = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entity.key().location());
        Entity clazz = f.create(level);
        if (clazz instanceof Mob) {
            Mob hurtMob = (Mob)clazz;
            Object maid = MobUtil.getNearestMob((LivingEntity)serverPlayer, 30.0, hurtMob.getClass(), null);
            Mob animal = MobUtil.getNearestMob((LivingEntity)serverPlayer, 30.0, Mob.class, maid);
            if (maid != null && animal != null) {
                maid.hurt(maid.damageSources().mobAttack((LivingEntity)animal), 1.0f);
                maid.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200));
                animal.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200));
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)LangDefinition.MOB_HIT_MOB, (Object[])new Object[]{animal.getName().getString(), maid.getName().getString()}));
            }
        }
        return 1;
    }
}

