/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.yzqdev.mod.jeanmod.command.RandomSetSampler;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class SampleCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder pack = Commands.literal((String)"sample");
        LiteralArgumentBuilder give = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"give").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"item", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            BuiltInRegistries.ITEM.keySet().forEach(i -> builder.suggest(i.toString()));
            return builder.buildFuture();
        }).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(SampleCommand::give))));
        LiteralArgumentBuilder manyItem = (LiteralArgumentBuilder)Commands.literal((String)"many_item").then(Commands.argument((String)"item_id", (ArgumentType)ResourceLocationArgument.id()).suggests((context, builder) -> {
            BuiltInRegistries.ITEM.keySet().forEach(i -> builder.suggest(i.toString()));
            return builder.buildFuture();
        }).then(Commands.argument((String)"item_count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)640000)).executes(context -> SampleCommand.dropItems((CommandContext<CommandSourceStack>)context))));
        LiteralArgumentBuilder randomItem = (LiteralArgumentBuilder)Commands.literal((String)"random").executes(source -> SampleCommand.dropRandomItem((CommandContext<CommandSourceStack>)source));
        LiteralArgumentBuilder platform = (LiteralArgumentBuilder)Commands.literal((String)"platform").executes(source -> SampleCommand.generatePlatform((Player)((CommandSourceStack)source.getSource()).getPlayerOrException()));
        pack.then((ArgumentBuilder)give);
        pack.then((ArgumentBuilder)manyItem);
        pack.then((ArgumentBuilder)randomItem);
        pack.then((ArgumentBuilder)platform);
        return pack;
    }

    private static int dropRandomItem(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
        Level level = serverPlayer.level();
        List<ResourceLocation> resourceLocations = RandomSetSampler.getRandomElements(BuiltInRegistries.ITEM.keySet(), 36);
        for (ResourceLocation i : resourceLocations) {
            Item item = (Item)BuiltInRegistries.ITEM.get(i);
            ItemEntity itementity = new ItemEntity(level, serverPlayer.getX() + 3.0, serverPlayer.getY(), serverPlayer.getZ(), new ItemStack((ItemLike)item, new ItemStack((ItemLike)item).getMaxStackSize()));
            level.addFreshEntity((Entity)itementity);
        }
        return 1;
    }

    private static int give(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = EntityArgument.getPlayer(context, (String)"player");
            ResourceLocation itemId = ResourceLocationArgument.getId(context, (String)"item");
            int count = IntegerArgumentType.getInteger(context, (String)"count");
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)LangDefinition.item_not_exist));
                return 0;
            }
            ItemStack stack = new ItemStack((ItemLike)item, count);
            player.addItem(stack);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)LangDefinition.give_player_some_item, (Object[])new Object[]{player.getName().getString(), count, itemId}), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)LangDefinition.command_failed, (Object[])new Object[]{e.getMessage()}));
            return 0;
        }
    }

    private static int dropItems(CommandContext<CommandSourceStack> ctx) {
        ServerPlayer serverPlayer = ((CommandSourceStack)ctx.getSource()).getPlayer();
        ResourceLocation res = ResourceLocationArgument.getId(ctx, (String)"item_id");
        int count = IntegerArgumentType.getInteger(ctx, (String)"item_count");
        Level level = serverPlayer.level();
        Item item = (Item)BuiltInRegistries.ITEM.get(res);
        for (int i = 0; i < count; ++i) {
            ItemEntity itementity = new ItemEntity(level, serverPlayer.getX() + 3.0, serverPlayer.getY(), serverPlayer.getZ(), new ItemStack((ItemLike)item, new ItemStack((ItemLike)item).getMaxStackSize()));
            level.addFreshEntity((Entity)itementity);
        }
        return 1;
    }

    private static int generatePlatform(Player player) {
        Direction direction = player.getDirection();
        BlockPos centerPos = player.blockPosition().relative(direction, 3).below();
        Level world = player.level();
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                BlockPos pos = centerPos.offset(x, 0, z);
                if (!world.isEmptyBlock(pos)) continue;
                world.setBlock(pos, Blocks.STONE.defaultBlockState(), 3);
            }
        }
        world.playSound(null, centerPos, SoundEvents.STONE_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)centerPos.getX(), (double)centerPos.getY(), (double)centerPos.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
        }
        return 1;
    }
}

