/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.compat.jade;

import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.entity.elf.EntityElf;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.ItemStack;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum MaidProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation MAID;

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity maidLevel2;
        TamableAnimal maid;
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof Maid) {
            maid = (Maid)entity;
            int maidLevel2 = maid.getLevel(maid);
            int maidExp = maid.getExp(maid);
            int remain = 20 + maidLevel2 * 20 - maidExp;
            iTooltip.add((Component)Component.translatable((String)LangDefinition.maid_level_jade).append((Component)Component.literal((String)String.valueOf(maidLevel2)).withStyle(ChatFormatting.AQUA)));
            iTooltip.add((Component)Component.translatable((String)LangDefinition.maid_level_require_xp).append(String.valueOf(remain)));
        }
        if ((maidLevel2 = entityAccessor.getEntity()) instanceof EntityElf && (maid = (EntityElf)maidLevel2).isTame()) {
            iTooltip.add((Component)Component.translatable((String)LangDefinition.sit_status).append(String.valueOf(maid.isInSittingPose())));
        }
        if ((maidLevel2 = entityAccessor.getEntity()) instanceof Gangster) {
            ListTag itemTags;
            Gangster gangster = (Gangster)maidLevel2;
            CompoundTag data = entityAccessor.getServerData();
            if (data.contains("inv") && !(itemTags = data.getList("inv", 10)).isEmpty()) {
                iTooltip.add((Component)Component.translatable((String)LangDefinition.gangster_backpack));
                iTooltip.add((Component)Component.literal((String)""));
                itemTags.forEach(item -> {
                    IElementHelper elements = IElementHelper.get();
                    IElement icon = elements.item(ItemStack.parseOptional((HolderLookup.Provider)gangster.registryAccess(), (CompoundTag)((CompoundTag)item)), 0.8f);
                    iTooltip.append(icon);
                });
            }
        }
    }

    public ResourceLocation getUid() {
        return MAID;
    }

    public void appendServerData(CompoundTag compoundTag, EntityAccessor entityAccessor) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof Maid) {
            Maid maid = (Maid)entity;
            int maidLevel = maid.getLevel(maid);
            int maidExp = maid.getExp(maid);
            compoundTag.putInt("level", maidLevel);
            compoundTag.putInt("exp", maidExp);
        }
        if (entity instanceof Gangster) {
            Gangster villager = (Gangster)entity;
            ArrayList itemStacks = new ArrayList();
            SimpleContainer gangsterInv = villager.getInventory();
            ListTag listTag = new ListTag();
            for (int i = 0; i < gangsterInv.getContainerSize(); ++i) {
                ItemStack itemStack = gangsterInv.getItem(i);
                if (itemStack.isEmpty()) continue;
                listTag.add((Object)itemStack.save((HolderLookup.Provider)villager.registryAccess()));
            }
            compoundTag.put("inv", (Tag)listTag);
        }
    }

    static {
        MAID = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"maid");
    }
}

