/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.datagen;

import com.yzqdev.mod.jeanmod.block.ModBlocks;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.datagen.LangUtil;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public class ModEnLangProvider
extends LanguageProvider {
    public ModEnLangProvider(PackOutput output) {
        super(output, "jean", "en_us");
    }

    protected void addTranslations() {
        this.generateTranslations();
    }

    public void generateTranslations() {
        this.addSimpleText();
        this.addItems();
        this.addSpawnEggItems();
    }

    private void addSimpleText() {
        this.add("stf.time", "Game startup time: %.2f seconds");
        this.add("mod.name", "Jean");
        this.add("stf.kill", "Defeated 99% of players nationwide");
        this.add("jean.modname", "Jean");
        this.add("config.jade.plugin_jean.maid_inv", "Show Maid Inventory");
        this.add("config.jade.plugin_jean.villager", "Show Iron Golem and Villager Status");
        this.add("config.jade.plugin_jean.maid", "Show Maid and Gangster Status");
        this.add(LangUtil.text("run_command"), "Execute command: ");
        this.add(LangUtil.gui("first_gui_title"), "Select Voice and Color");
        this.add(LangUtil.text("first_gui.save"), "Save");
        this.add(LangUtil.text("bind_gui.confirm"), "Save ");
        this.add(LangUtil.event("get_entity_uuid"), "Entity UUID copied: ");
        this.add(LangUtil.event("get_entity_id"), "Entity ID copied: ");
        this.add(LangDefinition.get_block_id, "Block ID copied: ");
        this.add(LangDefinition.MOB_HIT_MOB, "%s hit %s");
        this.add(LangDefinition.command_item, "\u00a7bCommand Orb");
        this.add(LangDefinition.input_enter_text, "Enter text");
        this.add(LangDefinition.input_enter_text_here, "Enter text here...");
        this.add(LangDefinition.no_item_in_hand, "You're not holding any item!");
        this.add(LangDefinition.container_full, "No items to transfer or container is full!");
        this.add(LangDefinition.player_return_home, "Player returned to home position!");
        this.add(LangDefinition.command_item_tooltip, "Command: %s");
        this.add(LangDefinition.elf_appear, "Maid Elf appeared!");
        this.add(LangDefinition.maid_backpack_content, "Maid Backpack Contents:");
        this.add(LangDefinition.no_home_set, "No home position set!");
        this.add(LangDefinition.item_not_exist, "Item doesn't exist!");
        this.add(LangDefinition.give_player_some_item, "Given %s %s x %s");
        this.add(LangDefinition.command_failed, "Execution failed: %s");
        this.add(LangDefinition.success_transfer_item, "Successfully transferred %s items!");
        this.add(LangDefinition.success_copy_item, "Copied %s items!");
        this.add(LangDefinition.maid_level_jade, "Level: ");
        this.add(LangDefinition.maid_level_require_xp, "XP required for next level: ");
        this.add(LangDefinition.player_created, "Player created");
        this.add(LangDefinition.remains_ingot, "Remaining ingots:");
        this.add(LangDefinition.villager_backpack, "Villager Backpack:");
        this.add(LangDefinition.sit_status, "Status: ");
        this.add(LangDefinition.cusor_to_a_block, "Please aim at a container block!");
        this.add(LangDefinition.box_not_a_container, "Target block is not a container!");
        this.add(LangDefinition.set_home_at, "Set home at %s");
        this.add(LangDefinition.gangster_backpack, "Gangster Backpack:");
        this.add(LangDefinition.burn_time, "Burn time: %s");
        this.add(LangDefinition.tag_durability, "Durability: %s");
        this.add(LangDefinition.bee_empty, "Empty");
        this.add(LangDefinition.bees, "Bees: %s");
        this.add(LangDefinition.bee_level, "Honey level: %s");
        this.add(LangDefinition.tag_clock, "Day %s); %s");
        this.add(LangDefinition.tag_coords, "X: %s Y: %s Z: %s");
        this.add(LangDefinition.tag_distance, "Distance: %s blocks");
        this.add(LangDefinition.item_tags, "Item Tags");
        this.add(LangDefinition.block_tags, "Block Tags");
        this.add(LangDefinition.press_b_show_info, "Hold %s to show components");
        this.add(LangDefinition.press_v_show_info, "Hold %s to show tags");
        this.add(LangDefinition.v_button, "V");
        this.add(LangDefinition.b_button, "B");
        this.add(LangDefinition.tag_more, "More");
        this.add(LangDefinition.copied, "%s copied");
        this.add(LangDefinition.copied_no, "%s has no components");
        this.add(LangDefinition.slot_is_empty, "Slot is empty");
        this.add((Item)ModItems.ORE_CLEANER_ITEM.get(), "\u77ff\u77f3\u91c7\u96c6\u5668");
        this.add(LangDefinition.block_cleard, "\u6e05\u9664\u5b8c\u6210! \u79fb\u9664\u4e86 %s \u4e2a\u975e\u77ff\u77f3\u65b9\u5757");
        this.add(LangDefinition.villager_inv, "\u6253\u5f00\u6751\u6c11\u80cc\u5305");
    }

    private void addItems() {
        this.addItem((Supplier)ModItems.COMMAND_ITEM, "Command Orb");
        this.addItem((Supplier)ModItems.RELEASE_PET_ITEM, "Pet Release Orb");
        this.addItem((Supplier)ModItems.NIGHT_VISION_CARROT, "Night Vision Carrot");
        this.addItem((Supplier)ModItems.COPY_ID_ITEM, "Copy ID");
        this.addItem((Supplier)ModItems.CHAIR_ME_ITEM, "Sit On My Head!");
        this.addItem((Supplier)ModItems.BAMBOO_COAL, "Bamboo Charcoal");
        this.addItem((Supplier)ModItems.EXP_BOTTLE, "Experience Bottle");
        this.addBlock((Supplier)ModBlocks.COMPRESSED_BARRELS, "Compressed Barrels");
    }

    private void addSpawnEggItems() {
        this.addSpawnEggItem((EntityType)ModEntities.MAID_ENTITY_TYPE.get(), "Cardboard");
        this.addSpawnEggItem((EntityType)ModEntities.GANGSTER.get(), "Gangster");
        this.addSpawnEggItem((EntityType)ModEntities.HUMAN.get(), "Human");
        this.addSpawnEggItem((EntityType)ModEntities.ELF.get(), "Maid Elf");
        this.addSpawnEggItem((EntityType)ModEntities.GIANT_MINER.get(), "Giant");
    }

    private void addSpawnEggItem(EntityType entityType, String name) {
        this.add(entityType, name);
        this.add("item.jean." + EntityType.getKey((EntityType)entityType).getPath() + "_spawn_egg", name + " Spawn Egg");
    }
}

