/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity;

import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.entity.elf.EntityElf;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.EntityDanmaku;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import com.yzqdev.mod.jeanmod.entity.giant.GiantMiner;
import com.yzqdev.mod.jeanmod.entity.human.Human;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"jean");
    public static final Map<Holder<EntityType<?>>, Supplier<AttributeSupplier.Builder>> ATTRIBUTES = new HashMap();
    public static final Map<Holder<EntityType<?>>, SpawnPlacements.SpawnPredicate<?>> SPAWN_PREDICATES = new HashMap();
    public static final DeferredRegister.Items SPAWN_EGGS = DeferredRegister.createItems((String)"jean");
    public static final DeferredHolder<EntityType<?>, EntityType<Human>> HUMAN = ModEntities.registerWithEgg("human", EntityType.Builder.of(Human::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.5f), 2174634, 0x9A9A9A);
    public static final DeferredHolder<EntityType<?>, EntityType<EntityElf>> ELF = ModEntities.registerWithEgg("elf", EntityType.Builder.of(EntityElf::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.7f), 2169682, 3840554);
    public static final DeferredHolder<EntityType<?>, EntityType<GiantMiner>> GIANT_MINER = ModEntities.registerWithEgg("giant_miner", EntityType.Builder.of(GiantMiner::new, (MobCategory)MobCategory.CREATURE).sized(2.4f, 7.2f), 0x2FF22F, 0x3E3F3F);
    public static final DeferredHolder<EntityType<?>, EntityType<Maid>> MAID_ENTITY_TYPE = ModEntities.registerWithEgg("maid", EntityType.Builder.of(Maid::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.7f), 3085359, 3952447);
    public static final DeferredHolder<EntityType<?>, EntityType<Gangster>> GANGSTER = ModEntities.registerWithEgg("gangster", EntityType.Builder.of(Gangster::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 1.8f), 2174634, 0x9A9A2A);
    public static final DeferredHolder<EntityType<?>, EntityType<EntityDanmaku>> ENTITY_DANMAKU = ENTITY_TYPES.register("danmuku", () -> EntityDanmaku.TYPE);

    public static <E extends Mob> DeferredHolder<EntityType<?>, EntityType<E>> registerWithEgg(String name, EntityType.Builder<E> builder, int primaryColor, int secondaryColor) {
        DeferredHolder ret = ENTITY_TYPES.register(name, () -> builder.build(name));
        SPAWN_EGGS.register(name + "_spawn_egg", () -> new SpawnEggItem((EntityType)ret.get(), primaryColor, secondaryColor, new Item.Properties()));
        return ret;
    }

    private static ResourceKey<EntityType<?>> createIDFor(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)JeanMod.prefix(name));
    }

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
        SPAWN_EGGS.register(eventBus);
    }
}

