/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.elf.elf;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuColor;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuType;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.EntityDanmaku;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class EntityDanmakuRenderer
extends EntityRenderer<EntityDanmaku> {
    private static final ResourceLocation DANMAKU_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"textures/entity/danmaku.png");
    private static final RenderType RENDER_TYPE = RenderType.itemEntityTranslucentCull((ResourceLocation)DANMAKU_TEXTURE);

    public EntityDanmakuRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    private static void vertex(VertexConsumer bufferIn, Matrix4f pose, Matrix3f normal, double x, double y, double texU, double texV, int packedLight) {
        Vector3f vector3f = normal.transform(new Vector3f(0.0f, 1.0f, 0.0f));
        bufferIn.addVertex(pose, (float)x, (float)y, 0.0f).setColor(255, 255, 255, 255).setUv((float)texU, (float)texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(vector3f.x(), vector3f.y(), vector3f.z());
    }

    public void render(EntityDanmaku entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn) {
        DanmakuColor color = entity.getColor();
        DanmakuType type = entity.getDanmakuType();
        int width = 416;
        int length = 128;
        double startU = 32 * color.ordinal();
        double startV = 32 * type.ordinal();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.1, 0.0);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        VertexConsumer buffer = bufferIn.getBuffer(RENDER_TYPE);
        PoseStack.Pose poseStackLast = poseStack.last();
        Matrix4f pose = poseStackLast.pose();
        Matrix3f normal = poseStackLast.normal();
        EntityDanmakuRenderer.vertex(buffer, pose, normal, -type.getSize(), type.getSize(), (startU + 0.0) / (double)width, (startV + 0.0) / (double)length, packedLightIn);
        EntityDanmakuRenderer.vertex(buffer, pose, normal, -type.getSize(), -type.getSize(), (startU + 0.0) / (double)width, (startV + 32.0) / (double)length, packedLightIn);
        EntityDanmakuRenderer.vertex(buffer, pose, normal, type.getSize(), -type.getSize(), (startU + 32.0) / (double)width, (startV + 32.0) / (double)length, packedLightIn);
        EntityDanmakuRenderer.vertex(buffer, pose, normal, type.getSize(), type.getSize(), (startU + 32.0) / (double)width, (startV + 0.0) / (double)length, packedLightIn);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(EntityDanmaku entity) {
        return DANMAKU_TEXTURE;
    }
}

