/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.elf.projectile;

import com.google.common.base.Preconditions;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuColor;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.DanmakuType;
import com.yzqdev.mod.jeanmod.entity.elf.projectile.EntityDanmaku;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public final class DanmakuShoot {
    private static final Random RANDOM = new Random();
    private static final double MAX_YAW = Math.PI * 2;
    private static final int MIN_FAN_NUM = 2;
    private Level world = null;
    private LivingEntity thrower = null;
    private LivingEntity target = null;
    private DanmakuColor color = DanmakuColor.RED;
    private DanmakuType type = DanmakuType.PELLET;
    private int impedingLevel = 0;
    private float gravity = 0.01f;
    private float damage = 1.0f;
    private float velocity = 0.2f;
    private float inaccuracy = 0.2f;
    private double yawTotal = 0.0;
    private int fanNum = 0;
    private boolean hurtEnderman = false;

    public static DanmakuShoot create() {
        return new DanmakuShoot();
    }

    public void aimedShot() {
        Preconditions.checkNotNull((Object)this.world);
        Preconditions.checkNotNull((Object)this.thrower);
        Preconditions.checkNotNull((Object)this.target);
        EntityDanmaku danmaku = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color).setImpedingLevel(this.impedingLevel).setHurtEnderman(this.hurtEnderman);
        float offset = 0.3f / this.target.getBbHeight();
        danmaku.shoot(this.target.getX() - this.thrower.getX(), this.target.getY() - this.thrower.getY() - (double)offset, this.target.getZ() - this.thrower.getZ(), this.velocity, this.inaccuracy);
        this.world.addFreshEntity((Entity)danmaku);
        this.world.playSound(null, this.thrower.getX(), this.thrower.getY(), this.thrower.getZ(), SoundEvents.SNOWBALL_THROW, this.thrower.getSoundSource(), 1.0f, 0.8f);
    }

    public void fanShapedShot() {
        Preconditions.checkNotNull((Object)this.world);
        Preconditions.checkNotNull((Object)this.thrower);
        Preconditions.checkNotNull((Object)this.target);
        Preconditions.checkArgument((this.yawTotal >= 0.0 && this.yawTotal <= Math.PI * 2 ? 1 : 0) != 0, (Object)"yaw should >=0 and <= 2\u03c0");
        float offset = 0.3f / this.target.getBbHeight();
        Vec3 v = new Vec3(this.target.getX() - this.thrower.getX(), this.target.getY() - this.thrower.getY() - (double)offset, this.target.getZ() - this.thrower.getZ());
        double yaw = -(this.yawTotal / 2.0);
        double addYaw = this.yawTotal / (double)(this.fanNum - 1);
        for (int i = 1; i <= this.fanNum; ++i) {
            Vec3 v1 = v.yRot((float)yaw);
            yaw += addYaw;
            EntityDanmaku danmaku = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color).setImpedingLevel(this.impedingLevel).setHurtEnderman(this.hurtEnderman);
            danmaku.shoot(v1.x, v1.y, v1.z, this.velocity * 2.0f, this.inaccuracy);
            EntityDanmaku danmaku2 = new EntityDanmaku(this.world, this.thrower).setDamage(this.damage).setGravityVelocity(this.gravity).setDanmakuType(this.type).setColor(this.color).setImpedingLevel(this.impedingLevel).setHurtEnderman(this.hurtEnderman);
            danmaku2.shoot(v1.x, v1.y, v1.z, this.velocity, this.inaccuracy);
            this.world.addFreshEntity((Entity)danmaku);
            this.world.addFreshEntity((Entity)danmaku2);
        }
        this.world.playSound(null, this.thrower.getX(), this.thrower.getY(), this.thrower.getZ(), SoundEvents.SNOWBALL_THROW, this.thrower.getSoundSource(), 1.0f, 0.8f);
    }

    public DanmakuShoot setWorld(Level world) {
        this.world = world;
        return this;
    }

    public DanmakuShoot setThrower(LivingEntity thrower) {
        this.thrower = thrower;
        return this;
    }

    public DanmakuShoot setColor(DanmakuColor color) {
        this.color = color;
        return this;
    }

    public DanmakuShoot setRandomColor() {
        this.color = DanmakuColor.random(RANDOM);
        return this;
    }

    public DanmakuShoot setType(DanmakuType type) {
        this.type = type;
        return this;
    }

    public DanmakuShoot setRandomType() {
        this.type = DanmakuType.random(RANDOM);
        return this;
    }

    public DanmakuShoot setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public DanmakuShoot setDamage(float damage) {
        this.damage = damage;
        return this;
    }

    public DanmakuShoot setTarget(LivingEntity target) {
        this.target = target;
        return this;
    }

    public DanmakuShoot setVelocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public DanmakuShoot setInaccuracy(float inaccuracy) {
        this.inaccuracy = inaccuracy;
        return this;
    }

    public DanmakuShoot setYawTotal(double yawTotal) {
        this.yawTotal = yawTotal;
        return this;
    }

    public DanmakuShoot setFanNum(int fanNum) {
        this.fanNum = fanNum;
        return this;
    }

    public DanmakuShoot setImpedingLevel(int level) {
        this.impedingLevel = level;
        return this;
    }

    public DanmakuShoot setHurtEnderman(boolean hurtEnderman) {
        this.hurtEnderman = hurtEnderman;
        return this;
    }
}

