/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.gangster;

import com.google.common.collect.ImmutableSet;
import com.yzqdev.mod.jeanmod.entity.ModSensorTypes;
import com.yzqdev.mod.jeanmod.entity.gangster.Gangster;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class GansterPickupEntitiesSensor
extends Sensor<Gangster> {
    private static final int VERTICAL_SEARCH_RANGE = 4;

    public GansterPickupEntitiesSensor() {
        super(30);
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()));
    }

    protected void doTick(ServerLevel worldIn, Gangster gangster) {
        float radius = 50.0f;
        AABB aabb = gangster.hasRestriction() ? new AABB(gangster.getRestrictCenter()).inflate((double)radius, 4.0, (double)radius) : gangster.getBoundingBox().inflate((double)radius, 4.0, (double)radius);
        List allEntities = worldIn.getEntitiesOfClass(Entity.class, aabb, Entity::isAlive);
        allEntities.sort(Comparator.comparingDouble(arg_0 -> ((Gangster)gangster).distanceToSqr(arg_0)));
        List optional = allEntities.stream().filter(e -> e.closerThan((Entity)gangster, (double)(radius + 1.0f))).filter(e -> gangster.isWithinRestriction(e.blockPosition())).filter(arg_0 -> ((Gangster)gangster).hasLineOfSight(arg_0)).collect(Collectors.toList());
        gangster.getBrain().setMemory((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get(), optional);
    }
}

