/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import com.yzqdev.mod.jeanmod.JeanMod;
import com.yzqdev.mod.jeanmod.block.ModBlocks;
import com.yzqdev.mod.jeanmod.entity.ModEntities;
import com.yzqdev.mod.jeanmod.entity.ModSensorTypes;
import com.yzqdev.mod.jeanmod.entity.maid.MaidAi;
import com.yzqdev.mod.jeanmod.inventory.maid.MaidScreenHandler;
import com.yzqdev.mod.jeanmod.item.ModTags;
import com.yzqdev.mod.jeanmod.network.NetworkHandler;
import com.yzqdev.mod.jeanmod.network.PlayMaidSoundPackage;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.SoundUtil;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Maid
extends TamableAnimal
implements GeoEntity,
InventoryCarrier {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> DATA_BEGGING = SynchedEntityData.defineId(Maid.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<String> DATA_SOUND_PACK_ID = SynchedEntityData.defineId(Maid.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_LEVEL = SynchedEntityData.defineId(Maid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_EXP = SynchedEntityData.defineId(Maid.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int MAX_HEALTH = 50;
    private final String DATA_SOUND_PACK_ID_TAG = "data_sound_pack_id_tag";
    public static final String MAID_INVENTORY_TAG = "MaidInventory";
    private boolean hasPetBed = false;
    private final SimpleContainer inventory = new SimpleContainer(72);
    private final SimpleContainer armorInv = new SimpleContainer(4);
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Maid>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.NEAREST_ITEMS, ModSensorTypes.MAID_HOSTILE_SENSOR.get(), (Object)((SensorType)ModSensorTypes.MAID_PICKUP_ENTITIES_SENSOR_SENSOR_TYPE.get()), (Object)((SensorType)ModSensorTypes.MAID_TEMPTATIONS.get()));
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_HOSTILE, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)((MemoryModuleType)ModSensorTypes.VISIBLE_PICKUP_ENTITIES.get()), (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object[])new MemoryModuleType[]{MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.PACIFIED, MemoryModuleType.IS_TEMPTED, MemoryModuleType.IS_PANICKING});
    private int pickupSoundCount = 5;

    public Maid(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.getNavigation().setCanFloat(true);
        this.setCanPickUpLoot(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, (double)0.4f).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public SimpleContainer getArmorInv() {
        return this.armorInv;
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ModTags.maidFood);
    }

    public float getRestrictRadius() {
        return 16.0f;
    }

    public boolean isWithinRestriction() {
        return this.isWithinRestriction(this.blockPosition());
    }

    public boolean isWithinRestriction(BlockPos pos) {
        if (this.hasRestriction()) {
            return this.getRestrictCenter().distSqr((Vec3i)pos) < (double)(this.getRestrictRadius() * this.getRestrictRadius());
        }
        return true;
    }

    protected Brain.Provider<Maid> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return MaidAi.makeBrain(this, (Brain<Maid>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Maid> getBrain() {
        return super.getBrain();
    }

    private boolean isInCombat() {
        LivingEntity target = this.getTarget();
        return target != null && target.isAlive();
    }

    public void aiStep() {
        super.aiStep();
        if (this.tickCount % 40 == 0) {
            if (!this.isInCombat()) {
                if (!this.level().isClientSide && this.isAlive() && this.isTame()) {
                    this.heal(1.0f);
                }
            } else if (!this.level().isClientSide && this.isAlive() && this.isTame()) {
                this.heal(2.0f);
            }
        }
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    protected void customServerAiStep() {
        this.level().getProfiler().push("maidBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("maidActivityUpdate");
        MaidAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    public static boolean checkMaidSpawnRules(@NotNull EntityType<Maid> type, @NotNull LevelAccessor level, MobSpawnType spawnType, @NotNull BlockPos pos, @NotNull RandomSource random) {
        return true;
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (sound.getLocation().getPath().contains("maid")) {
            NetworkHandler.sendToNearby((Entity)this, new PlayMaidSoundPackage(sound.getLocation(), this.getSoundPackId(), this.getId()), 16);
        } else {
            super.playSound(sound, volume, pitch);
        }
    }

    public String getSoundPackId() {
        return (String)this.entityData.get(DATA_SOUND_PACK_ID);
    }

    public void setSoundPackId(String soundPackId) {
        this.entityData.set(DATA_SOUND_PACK_ID, (Object)soundPackId);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        if (this.getTarget() != null) {
            return SoundUtil.attackSound(this, (SoundEvent)ModSoundEvents.MAID_IDLE.get(), 0.7f);
        }
        return SoundUtil.environmentSound(this, (SoundEvent)ModSoundEvents.MAID_IDLE.get(), 0.5f);
    }

    protected SoundEvent getHurtSound(DamageSource pDamageSource) {
        if (pDamageSource.getEntity() instanceof Player) {
            return (SoundEvent)ModSoundEvents.MAID_PLAYER.get();
        }
        return (SoundEvent)ModSoundEvents.MAID_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSoundEvents.MAID_DEATH.get();
    }

    public float getVoicePitch() {
        return 1.0f;
    }

    protected boolean canReplaceCurrentItem(ItemStack candidate, ItemStack existing) {
        return false;
    }

    protected void pushEntities() {
        super.pushEntities();
        List entityList = this.level().getEntities((Entity)this, this.getBoundingBox().inflate(0.5, 0.0, 0.5), i -> true);
        if (!entityList.isEmpty() && this.isAlive()) {
            for (Entity entity : entityList) {
                if (!(entity instanceof ItemEntity)) continue;
                ItemEntity itemEntity = (ItemEntity)entity;
                this.pickupItem(itemEntity, false);
            }
        }
    }

    public boolean pickupItem(ItemEntity entityItem, boolean simulate) {
        if (!this.level().isClientSide && entityItem.isAlive() && !entityItem.hasPickUpDelay()) {
            ItemStack itemstack = entityItem.getItem();
            int count = itemstack.getCount();
            if (count == (itemstack = this.inventory.addItem(itemstack)).getCount()) {
                return false;
            }
            if (!simulate) {
                this.take((Entity)entityItem, count - itemstack.getCount());
                --this.pickupSoundCount;
                if (this.pickupSoundCount == 0) {
                    this.playSound((SoundEvent)ModSoundEvents.MAID_ITEM_GET.get(), 1.0f, 1.0f);
                    this.pickupSoundCount = 5;
                }
                if (itemstack.isEmpty()) {
                    entityItem.discard();
                } else {
                    entityItem.setItem(itemstack);
                }
            }
            return true;
        }
        return false;
    }

    public int getLevel(TamableAnimal entity) {
        return (Integer)this.entityData.get(DATA_LEVEL);
    }

    public void setLevel(TamableAnimal entity, int level) {
        if (level < 51) {
            this.entityData.set(DATA_LEVEL, (Object)level);
            this.onLevelUp();
        }
    }

    public int getExp(TamableAnimal entity) {
        return (Integer)this.entityData.get(DATA_EXP);
    }

    public int setExp(int exp) {
        this.entityData.set(DATA_EXP, (Object)exp);
        return (Integer)this.entityData.get(DATA_EXP);
    }

    public void addExp(TamableAnimal entity, int exp) {
        int currentExp = this.getExp(entity);
        int currentLevel = this.getLevel(entity);
        int requiredExp = 50 + 20 * currentLevel;
        if ((currentExp += exp) >= requiredExp) {
            this.setLevel(entity, currentLevel + 1);
            currentExp -= requiredExp;
        }
        this.entityData.set(DATA_EXP, (Object)Math.max(currentExp, 0));
    }

    public boolean canAttack(LivingEntity pTarget) {
        LivingEntity livingEntity;
        if (this.isTame() && (livingEntity = this.getOwner()) instanceof Player) {
            LivingEntity lastHurtByMob;
            Player player = (Player)livingEntity;
            if (this.isInSittingPose()) {
                return false;
            }
            if (pTarget instanceof Player) {
                return false;
            }
            if (pTarget instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)pTarget;
                if (player.getUUID().equals(tamableAnimal.getOwnerUUID())) {
                    return false;
                }
            }
            if (pTarget.equals((Object)(lastHurtByMob = player.getLastHurtByMob()))) {
                return true;
            }
            LivingEntity lastHurtMob = player.getLastHurtMob();
            if (pTarget.equals((Object)lastHurtMob)) {
                return true;
            }
        }
        if (pTarget instanceof Enemy) {
            return true;
        }
        LivingEntity maidLastHurtByMob = this.getLastHurtByMob();
        return pTarget.equals((Object)maidLastHurtByMob);
    }

    public void getAvailableInv() {
    }

    public LivingEntity getTarget() {
        return this.brain.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean flag = super.hurt(source, amount);
        if (this.level().isClientSide) {
            return false;
        }
        if (flag && source.getEntity() instanceof LivingEntity) {
            this.triggerAnim("attacked_controller", "attacked");
            MaidAi.wasHurtBy(this, (LivingEntity)source.getEntity());
        }
        return flag;
    }

    public boolean isWithinMeleeAttackRange(LivingEntity target) {
        float attackDistance = 2.0f + (float)this.getLevel(this) / 3.0f;
        return this.distanceTo((Entity)target) < attackDistance;
    }

    public void setInSittingPose(boolean inSittingPose) {
        super.setInSittingPose(inSittingPose);
        this.setOrderedToSit(inSittingPose);
        if (inSittingPose) {
            this.getNavigation().stop();
            this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            this.setTarget(null);
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_LEVEL, (Object)0);
        builder.define(DATA_EXP, (Object)0);
        builder.define(DATA_BEGGING, (Object)false);
        builder.define(DATA_SOUND_PACK_ID, (Object)"atri_sound_pack");
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readInventoryFromTag(tag, (HolderLookup.Provider)this.registryAccess());
        this.setLevel(this, tag.getInt("Level"));
        this.addExp(this, tag.getInt("Exp"));
        this.hasPetBed = tag.getString("PetHomeEntityData") != null;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("Level", this.getLevel(this));
        tag.putInt("Exp", this.getExp(this));
        tag.putString("data_sound_pack_id_tag", "atri_sound_pack");
        this.writeInventoryToTag(tag, (HolderLookup.Provider)this.registryAccess());
    }

    public void onLevelUp() {
        Maid entity = this;
        int level = this.getLevel(entity);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(100.0 + (double)(level * 10));
        this.setHealth(100.0f + (float)(level * 10));
        AttributeInstance maidDamage = this.getAttribute(Attributes.ATTACK_DAMAGE);
        if (maidDamage.getBaseValue() < 30.0) {
            maidDamage.setBaseValue(3.0 + (double)level);
        }
        if (level >= 15) {
            entity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, Integer.MAX_VALUE, 1));
        }
    }

    public double getMaidAttackDamage() {
        AttributeInstance health = this.getAttribute(Attributes.MAX_HEALTH);
        AttributeInstance maidDamage = this.getAttribute(Attributes.ATTACK_DAMAGE);
        return maidDamage.getBaseValue();
    }

    protected void applyTamingSideEffects() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(100.0);
            this.setHealth(100.0f);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(50.0);
        }
    }

    public boolean isBegging() {
        return (Boolean)this.entityData.get(DATA_BEGGING);
    }

    public void setBegging(boolean begging) {
        this.entityData.set(DATA_BEGGING, (Object)begging);
    }

    @NotNull
    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.level().isClientSide) {
            boolean flag = this.isOwnedBy((LivingEntity)player) || this.isTame();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.isFood(itemstack) && !this.isTame()) {
            if (itemstack.is(ModTags.maidFood)) {
                if (!player.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
                if (this.random.nextInt(3) == 0) {
                    this.tame(player);
                    this.setInSittingPose(true);
                    this.setTarget(null);
                    this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                } else {
                    this.level().broadcastEntityEvent((Entity)this, (byte)6);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
            if (itemstack.is(ModTags.maidFood)) {
                if (!this.isTame() || !this.isOwnedBy((LivingEntity)player)) {
                    return super.mobInteract(player, hand);
                }
                if (this.getHealth() != this.getMaxHealth()) {
                    this.heal(4.0f);
                    if (!player.getAbilities().instabuild) {
                        itemstack.shrink(1);
                    }
                } else {
                    return super.mobInteract(player, hand);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)10);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.mobInteract(player, hand);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)player)) {
                if (player.isShiftKeyDown()) {
                    this.setInSittingPose(!this.isInSittingPose());
                    this.jumping = false;
                    System.out.println("\u5750\u4e0b");
                    this.getNavigation().stop();
                    this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
                    this.setTarget(null);
                    return InteractionResult.SUCCESS;
                }
                if (player instanceof ServerPlayer) {
                    player.openMenu(new MenuProvider(){

                        public Component getDisplayName() {
                            return Maid.this.getDisplayName();
                        }

                        @Nullable
                        public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
                            return new MaidScreenHandler(pContainerId, pPlayerInventory, Maid.this.getId(), Maid.this.getMaidAttackDamage());
                        }
                    }, buf -> {
                        buf.writeInt(this.getId());
                        buf.writeDouble(this.getAttribute(Attributes.ATTACK_DAMAGE).getBaseValue());
                    });
                }
            }
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob otherParent) {
        Maid maidBaby = (Maid)((EntityType)ModEntities.MAID_ENTITY_TYPE.get()).create((Level)level);
        maidBaby.setOwnerUUID(this.getOwnerUUID());
        maidBaby.setTame(true, true);
        return maidBaby;
    }

    private void dropItem(ItemStack stack, LivingEntity entity) {
        if (!stack.isEmpty()) {
            ItemStack droppedStack = stack.copy();
            this.level().addFreshEntity((Entity)new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), droppedStack));
            stack.setCount(0);
        }
    }

    protected void dropEquipment() {
        super.dropEquipment();
        CompoundTag compoundTag = new CompoundTag();
        this.save(compoundTag);
        if (compoundTag.contains("PetHomeEntityData") && !compoundTag.getCompound("PetHomeEntityData").isEmpty()) {
            JeanMod.LOGGER.info("pet bed exist");
        } else {
            BlockPos pos = this.blockPosition();
            Level level = this.level();
            Direction face = this.getDirection();
            BlockPos leftPos = pos.relative(face);
            Vec3 position = Vec3.atBottomCenterOf((Vec3i)this.blockPosition());
            if (this.getY() < (double)(this.level().getMinBuildHeight() + 5)) {
                position = new Vec3(position.x, (double)(this.level().getMinBuildHeight() + 5), position.z);
            }
            if (this.getY() > (double)this.level().getMaxBuildHeight()) {
                position = new Vec3(position.x, (double)this.level().getMaxBuildHeight(), position.z);
            }
            BlockPos finalPos = GlobalHelper.vec3ToBlockPos(position);
            level.setBlock(finalPos, ((Block)ModBlocks.COMPRESSED_BARRELS.get()).defaultBlockState(), 3);
            IItemHandler containerHandler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, finalPos, (Object)Direction.NORTH);
            if (containerHandler != null) {
                this.getHandSlots().forEach(i -> ItemUtil.transferItem(i, containerHandler));
                this.armorInv.getItems().forEach(i -> ItemUtil.transferItem(i, containerHandler));
                this.inventory.getItems().forEach(i -> ItemUtil.transferItem(i, containerHandler));
            }
        }
    }

    private PlayState predicate(AnimationState animationState) {
        if (animationState.isMoving()) {
            double velocity = this.getDeltaMovement().length();
            Optional target = this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
            if (target.isPresent()) {
                animationState.getController().setAnimation(RawAnimation.begin().then("move.run", Animation.LoopType.LOOP));
            } else {
                animationState.getController().setAnimation(RawAnimation.begin().then("move.walk", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        animationState.getController().setAnimation(RawAnimation.begin().then("misc.idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState attackPredicate(AnimationState state) {
        if (this.swinging && state.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            state.getController().forceAnimationReset();
            state.getController().setAnimation(RawAnimation.begin().then("attack.strike", Animation.LoopType.PLAY_ONCE));
            this.swinging = false;
        }
        return PlayState.CONTINUE;
    }

    private PlayState jumpPredicate(AnimationState state) {
        if (this.isInWater() || this.onGround() || this.isPassenger() || this.hurtTime > 0) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    private PlayState diePredicate(AnimationState state) {
        if (this.isDeadOrDying()) {
            return state.setAndContinue(DefaultAnimations.DIE);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericLivingController((GeoAnimatable)this));
        controllers.add(new AnimationController((GeoAnimatable)this, "sit", 0, state -> {
            if (this.isInSittingPose()) {
                state.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.PLAY_ONCE));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", 0, this::attackPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "die", 0, this::diePredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "attacked_controller", event -> PlayState.STOP).triggerableAnim("attacked", RawAnimation.begin().then("attacked", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "eat_mainhand_controller", event -> PlayState.STOP).triggerableAnim("use_mainhand:eat", RawAnimation.begin().then("use_mainhand:eat", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "eat_controller", event -> PlayState.STOP).triggerableAnim("use_offhand:eat", RawAnimation.begin().then("use_offhand:eat", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, state -> {
            if (this.isPassenger()) {
                state.getController().setAnimation(RawAnimation.begin().then("chair", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "swim", 0, state -> {
            if (this.isInWater() && !this.onGround()) {
                state.getController().setAnimation(RawAnimation.begin().then("swim_stand", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "jumpController", 0, this::jumpPredicate));
        controllers.add(new AnimationController((GeoAnimatable)this, "tempt", 0, state -> {
            if (this.isBegging()) {
                state.getController().setAnimation(RawAnimation.begin().then("beg", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static boolean canSpawn(EntityType<Maid> maidEntityType, ServerLevelAccessor serverLevelAccessor, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        return true;
    }
}

