/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.entity.maid;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;

public class MaidHeldItemGeoLayer
extends BlockAndItemGeoLayer<Maid> {
    private static final String KEY_ITEM_LEFT_HAND = "itemLeftHand";
    private static final String KEY_ITEM_RIGHT_HAND = "itemRightHand";
    private static final String KEY_DRIPLEAF_RIGHT_HAND = "dripleaf_right_hand";

    public MaidHeldItemGeoLayer(GeoRenderer<Maid> renderer) {
        super(renderer);
    }

    @Nullable
    public ItemStack getStackForBone(GeoBone bone, Maid maid) {
        ItemStack mainStack = maid.getMainHandItem();
        ItemStack offStack = maid.getOffhandItem();
        switch (bone.getName()) {
            case "LeftHandLocator": {
                return offStack;
            }
            case "RightHandLocator": {
                return mainStack;
            }
        }
        return null;
    }

    @Nullable
    public BlockState getBlockForBone(GeoBone bone, Maid maid) {
        if (bone.getName().equals(KEY_DRIPLEAF_RIGHT_HAND)) {
            return Blocks.BIG_DRIPLEAF.defaultBlockState();
        }
        return null;
    }

    public ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, Maid maid) {
        return switch (bone.getName()) {
            case "LeftHandLocator", "RightHandLocator" -> ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
            default -> ItemDisplayContext.NONE;
        };
    }

    public void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, Maid maid, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
        ItemStack mainStack = maid.getMainHandItem();
        ItemStack offStack = maid.getOffhandItem();
        if (stack == mainStack) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            if (stack.getItem() instanceof ShieldItem) {
                poseStack.translate(0.0, 0.125, -0.25);
            }
            if (stack.getItem() instanceof TridentItem) {
                // empty if block
            }
        } else if (stack == offStack) {
            poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
            if (stack.getItem() instanceof ShieldItem) {
                poseStack.translate(0.0, 0.125, 0.25);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)maid, bufferSource, partialTick, packedLight, packedOverlay);
    }
}

