/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.event;

import com.mojang.serialization.DynamicOps;
import com.yzqdev.mod.jeanmod.Config;
import com.yzqdev.mod.jeanmod.bind.Constants;
import com.yzqdev.mod.jeanmod.datagen.LangDefinition;
import com.yzqdev.mod.jeanmod.event.TagInstance;
import com.yzqdev.mod.jeanmod.event.TextIcons;
import com.yzqdev.mod.jeanmod.item.ModItems;
import com.yzqdev.mod.jeanmod.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.glfw.GLFW;

@EventBusSubscriber(modid="jean", value={Dist.CLIENT})
public class TooltipEvent {
    private static <T> List<String> appendComponentValue(DynamicOps<Tag> ops, MutableComponent line, DataComponentType<T> type, T value) {
        if (value == null) {
            line.append((Component)Component.literal((String)"null").withStyle(ChatFormatting.RED));
            return List.of();
        }
        if (value instanceof Component) {
            Component c = (Component)value;
            line.append((Component)Component.empty().withStyle(ChatFormatting.GOLD).append(c));
        }
        try {
            Tag tag = (Tag)type.codecOrThrow().encodeStart(ops, value).getOrThrow();
            line.append(NbtUtils.toPrettyComponent((Tag)tag));
            return List.of();
        }
        catch (Throwable ex) {
            line.append((Component)Component.literal((String)String.valueOf(value)).withStyle(ChatFormatting.RED));
            ArrayList<String> lines = new ArrayList<String>();
            ex.printStackTrace();
            return lines;
        }
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        boolean advanced = event.getFlags().isAdvanced();
        if (itemStack.isEmpty()) {
            return;
        }
        if (itemStack.getItem() == ModItems.COMMAND_ITEM.get() && itemStack.has(Constants.commandNbt)) {
            String customValue = (String)itemStack.get(Constants.commandNbt);
            MutableComponent cmdTxt = Component.literal((String)(customValue == null ? "" : customValue)).withStyle(Style.EMPTY.withColor(ChatFormatting.RED));
            event.getToolTip().add(Component.translatable((String)LangDefinition.command_item_tooltip, (Object[])new Object[]{cmdTxt}));
        }
        Minecraft mc = Minecraft.getInstance();
        List lines = event.getToolTip();
        TooltipFlag flags = event.getFlags();
        long window = Minecraft.getInstance().getWindow().getWindow();
        if (GLFW.glfwGetKey((long)window, (int)66) == 1) {
            int count = 0;
            for (TypedDataComponent t : itemStack.getComponents()) {
                if (count < 5) {
                    event.getToolTip().add(Component.literal((String)t.type().toString()).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(" " + String.valueOf(t.value()))).withStyle(ChatFormatting.DARK_GRAY)));
                }
                ++count;
            }
            if (count >= 5) {
                event.getToolTip().add(Component.translatable((String)LangDefinition.tag_more, (Object[])new Object[]{count - 5}).withStyle(ChatFormatting.DARK_GRAY));
            }
        } else if (Config.showPressKeyInfo) {
            event.getToolTip().add(Component.translatable((String)LangDefinition.press_b_show_info, (Object[])new Object[]{Component.translatable((String)LangDefinition.b_button).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
        }
        Collection<ResourceLocation> iTag = ItemUtil.getTags(itemStack.getTags());
        if (GLFW.glfwGetKey((long)window, (int)86) == 1) {
            Collection<ResourceLocation> iTag2;
            Block blockFromItem;
            if (!iTag.isEmpty()) {
                event.getToolTip().add(Component.translatable((String)LangDefinition.item_tags).withStyle(ChatFormatting.GRAY));
                iTag.forEach(tag -> event.getToolTip().add(Component.literal((String)(" #" + tag.toString())).withStyle(ChatFormatting.DARK_GRAY)));
            }
            if ((blockFromItem = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR && !(iTag2 = ItemUtil.getTags(blockFromItem.defaultBlockState().getTags())).isEmpty()) {
                event.getToolTip().add(Component.translatable((String)LangDefinition.block_tags).withStyle(ChatFormatting.GRAY));
                iTag2.forEach(tag2 -> event.getToolTip().add(Component.literal((String)(" #" + String.valueOf(tag2))).withStyle(ChatFormatting.DARK_GRAY)));
            }
        } else {
            Block block;
            if (iTag.isEmpty() && (block = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR) {
                iTag = ItemUtil.getTags(block.defaultBlockState().getTags());
            }
            if (!iTag.isEmpty() && Config.showPressKeyInfo) {
                event.getToolTip().add(Component.translatable((String)LangDefinition.press_v_show_info, (Object[])new Object[]{Component.translatable((String)LangDefinition.v_button).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            }
        }
        if (mc.level != null && Screen.hasAltDown()) {
            Registry components = BuiltInRegistries.DATA_COMPONENT_TYPE;
            RegistryOps ops = mc.level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            ArrayList<Object> arrayList = new ArrayList<Object>(0);
            for (Map.Entry entry : itemStack.getComponentsPatch().entrySet()) {
                ResourceLocation id = components.getKey((Object)((DataComponentType)entry.getKey()));
                if (id == null) continue;
                MutableComponent line = Component.empty();
                line.append((Component)TextIcons.icon(Component.literal((String)"Q.")));
                if (((Optional)entry.getValue()).isEmpty()) {
                    line.append((Component)Component.literal((String)"!"));
                }
                line.append((Component)Component.literal((String)TextIcons.reduce(id)).withStyle(ChatFormatting.YELLOW));
                if (((Optional)entry.getValue()).isPresent()) {
                    line.append((Component)Component.literal((String)"="));
                    List<String> componentValue = TooltipEvent.appendComponentValue((DynamicOps<Tag>)ops, line, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).get());
                    if (!componentValue.isEmpty()) {
                        lines.add(Component.literal((String)(TextIcons.reduce(id) + " errored, see log")).withStyle(ChatFormatting.DARK_RED));
                        arrayList.add("Failed to encode value of " + String.valueOf(id) + ": " + String.valueOf(((Optional)entry.getValue()).get()));
                        arrayList.addAll(componentValue);
                    }
                }
                lines.add(line);
            }
        } else if (Screen.hasShiftDown()) {
            Item fluid;
            Object blockTags;
            BlockItem item;
            LinkedHashMap<ResourceLocation, TagInstance> tempTagNames = new LinkedHashMap<ResourceLocation, TagInstance>();
            Stream itemTags = BuiltInRegistries.ITEM.getHolderOrThrow((ResourceKey)BuiltInRegistries.ITEM.getResourceKey((Object)itemStack.getItem()).orElseThrow()).tags();
            TagInstance.Type.ITEM.append(tempTagNames, itemTags);
            Item item2 = itemStack.getItem();
            if (item2 instanceof BlockItem) {
                item = (BlockItem)item2;
                blockTags = BuiltInRegistries.BLOCK.getHolderOrThrow((ResourceKey)BuiltInRegistries.BLOCK.getResourceKey((Object)item.getBlock()).orElseThrow()).tags();
                TagInstance.Type.BLOCK.append((Map<ResourceLocation, TagInstance>)tempTagNames, (Stream<? extends TagKey<?>>)blockTags);
            }
            if ((blockTags = itemStack.getItem()) instanceof BucketItem) {
                BucketItem bucket = (BucketItem)blockTags;
                fluid = bucket.content;
                if (fluid != Fluids.EMPTY) {
                    Stream fluidTags = BuiltInRegistries.FLUID.getHolderOrThrow((ResourceKey)BuiltInRegistries.FLUID.getResourceKey((Object)fluid).orElseThrow()).tags();
                    TagInstance.Type.FLUID.append(tempTagNames, fluidTags);
                }
            }
            if ((fluid = itemStack.getItem()) instanceof SpawnEggItem) {
                item = (SpawnEggItem)fluid;
                EntityType entityType = item.getType(itemStack);
                Stream entityTypeTags = BuiltInRegistries.ENTITY_TYPE.getHolderOrThrow((ResourceKey)BuiltInRegistries.ENTITY_TYPE.getResourceKey((Object)entityType).orElseThrow()).tags();
                TagInstance.Type.ENTITY.append(tempTagNames, entityTypeTags);
            }
            if (!tempTagNames.isEmpty()) {
                tempTagNames.values().stream().sorted().map(TagInstance::toText).forEach(lines::add);
            }
        }
        if (Config.showAsAdvanced || advanced) {
            boolean isFound2;
            String st;
            LocalPlayer player;
            int burnTime = itemStack.getBurnTime(null);
            if (burnTime > 0) {
                event.getToolTip().add(1, Component.translatable((String)LangDefinition.burn_time, (Object[])new Object[]{TooltipEvent.getTimeStringShort(burnTime / 20) + " (" + burnTime + ")"}).withStyle(ChatFormatting.GRAY));
            }
            if (itemStack.getMaxDamage() != 0 && itemStack.getDamageValue() == 0) {
                event.getToolTip().add(1, Component.translatable((String)LangDefinition.tag_durability, (Object[])new Object[]{itemStack.getMaxDamage()}).withStyle(ChatFormatting.GRAY));
            }
            if (itemStack.getItem() == Items.SUSPICIOUS_STEW) {
                if (Config.showInfoStew) {
                    ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
                    SuspiciousStewEffects suspiciousStewEffects = (SuspiciousStewEffects)itemStack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)SuspiciousStewEffects.EMPTY);
                    for (Map.Entry entry : suspiciousStewEffects.effects()) {
                        list.add(entry.createEffectInstance());
                    }
                    int line = 1;
                    for (MobEffectInstance effect : list) {
                        ClientLevel level;
                        MutableComponent mutableComponent = Component.translatable((String)effect.getDescriptionId());
                        MobEffect mobEffect = (MobEffect)effect.getEffect().value();
                        if (effect.getAmplifier() > 0) {
                            mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + effect.getAmplifier()))});
                        }
                        if (!effect.endsWithin(20) && (level = Minecraft.getInstance().level) != null) {
                            mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)level.tickRateManager().tickrate())});
                        }
                        String ss = mutableComponent.getString();
                        boolean isFound = event.getToolTip().stream().anyMatch(a -> a.getString().equals(ss));
                        if (isFound) continue;
                        int i = line++;
                        event.getToolTip().add(i, mutableComponent.withStyle(mobEffect.getCategory().getTooltipFormatting()));
                    }
                }
            } else if (itemStack.getItem() == Items.BEE_NEST || itemStack.getItem() == Items.BEEHIVE) {
                List de;
                if (Config.showInfoBees && (de = (List)itemStack.get(DataComponents.BEES)) != null) {
                    if (de.isEmpty()) {
                        event.getToolTip().add(1, Component.translatable((String)LangDefinition.bee_empty).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    } else {
                        event.getToolTip().add(1, Component.translatable((String)LangDefinition.bees, (Object[])new Object[]{de.size()}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                    BlockItemStateProperties dd = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
                    if (dd != null && !dd.isEmpty()) {
                        event.getToolTip().add(2, Component.translatable((String)LangDefinition.bee_level, (Object[])new Object[]{dd.get((Property)BeehiveBlock.HONEY_LEVEL)}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                }
            } else if (itemStack.getItem() == Items.CLOCK) {
                ClientLevel clientLevel;
                if (Config.showInfoClock && (clientLevel = Minecraft.getInstance().level) != null) {
                    event.getToolTip().add(1, Component.translatable((String)LangDefinition.tag_clock, (Object[])new Object[]{(int)((clientLevel.getDayTime() + 6000L) / 24000L) + 1, TooltipEvent.getGameTime((Level)clientLevel, Config.isTwelves)}));
                }
            } else if (itemStack.getItem() == Items.RECOVERY_COMPASS && Config.showInfoRecovery && (player = Minecraft.getInstance().player) != null) {
                player.getLastDeathLocation().ifPresent(globalPos -> {
                    event.getToolTip().add(1, Component.translatable((String)("biome." + globalPos.dimension().location().toLanguageKey())).withStyle(ChatFormatting.GRAY));
                    event.getToolTip().add(2, Component.translatable((String)LangDefinition.tag_coords, (Object[])new Object[]{globalPos.pos().getX(), globalPos.pos().getY(), globalPos.pos().getZ()}).withStyle(ChatFormatting.GRAY));
                    event.getToolTip().add(3, Component.translatable((String)LangDefinition.tag_distance, (Object[])new Object[]{String.format(Locale.ROOT, "%2d", TooltipEvent.distanceTo(player.blockPosition(), globalPos.pos()))}).withStyle(ChatFormatting.GRAY));
                });
            }
            if (Config.showModName && (st = TooltipEvent.getModName(itemStack)) != null && !(isFound2 = event.getToolTip().stream().anyMatch(t2 -> t2.getString().equals(st)))) {
                event.getToolTip().add(Component.literal((String)st).withStyle(ChatFormatting.BLUE));
            }
        }
    }

    private static String getTimeStringShort(int seconds) {
        int days = seconds / 86400;
        int n = seconds % 86400;
        int hours = n / 3600;
        int n2 = n % 3600;
        int minutes = n2 / 60;
        int secs = n2 % 60;
        String ss = days != 0 ? String.format("%02d:%02d:%02d:%02d", days, hours, minutes, secs) : (hours != 0 ? String.format("%02d:%02d:%02d", hours, minutes, secs) : String.format("%d:%02d", minutes, secs));
        return ss;
    }

    private static int distanceTo(BlockPos start, BlockPos end) {
        float f = start.getX() - end.getX();
        float f1 = start.getY() - end.getY();
        float f2 = start.getZ() - end.getZ();
        return (int)Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
    }

    @Nullable
    private static String getModName(ItemStack itemStack) {
        String modName = itemStack.getItem().getCreatorModId(itemStack);
        return ModList.get().getModContainerById(modName).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modName));
    }

    private static String getGameTime(Level level, boolean isTwelveHour) {
        int dayTime = (int)((level.getDayTime() + 6000L) % 24000L);
        int hours = dayTime / 1000;
        int minutes = (int)((double)(dayTime % 1000) / 16.666666666666668);
        String post = "";
        if (isTwelveHour) {
            if (hours >= 12) {
                hours -= 12;
                post = " PM";
            } else {
                post = " AM";
            }
        }
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + post;
    }
}

