/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory.golem;

import com.yzqdev.mod.jeanmod.inventory.ModMenus;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class GolemInventoryScreenHandler
extends AbstractContainerMenu {
    public IronGolem ironGolem;
    public Container ironGolemInventory;

    public static MenuProvider createMenuProvider(final IronGolem entityId) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return entityId.getDisplayName();
            }

            public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
                return new GolemInventoryScreenHandler(syncId, playerInventory, entityId.getId());
            }
        };
    }

    public GolemInventoryScreenHandler(int syncId, Inventory playerInventory, int ironGolemId) {
        super((MenuType)ModMenus.VILLAGER_INVENTORY_SCREEN_HANDLER.get(), syncId);
        Entity r = playerInventory.player.level().getEntity(ironGolemId);
        if (r instanceof IronGolem) {
            IronGolem abstractVillager;
            this.ironGolem = abstractVillager = (IronGolem)r;
            InventoryCarrier inventoryCarrier = (InventoryCarrier)this.ironGolem;
            this.ironGolemInventory = inventoryCarrier.getInventory();
        }
        int s = this.ironGolemInventory.getContainerSize();
        int r1 = s / 2;
        int c = s / r1;
        int xp = 81 + (88 - r1 * 18) / 2;
        int yp = 20 + (51 - c * 18) / 2;
        for (int i = 0; i < this.ironGolemInventory.getContainerSize(); ++i) {
            this.addSlot(new Slot(this, this.ironGolemInventory, i, xp + 18 * (i / 2), yp + 18 * (i % 2)){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(Items.IRON_INGOT);
                }
            });
        }
        for (int m = 0; m < 3; ++m) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + m * 9 + 9, 8 + l * 18, 84 + m * 18));
            }
        }
        for (int var14 = 0; var14 < 9; ++var14) {
            this.addSlot(new Slot((Container)playerInventory, var14, 8 + var14 * 18, 142));
        }
        final Container inv = this.ironGolemInventory;
        final IronGolem ironGolem = this.ironGolem;
        this.addSlotListener(new ContainerListener(){

            public void slotChanged(AbstractContainerMenu abstractContainerMenu, int i, ItemStack itemStack) {
                if (!inv.isEmpty()) {
                    ironGolem.setPlayerCreated(true);
                }
            }

            public void dataChanged(AbstractContainerMenu abstractContainerMenu, int i, int i1) {
                System.out.println(i);
            }
        });
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int invSlot) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(invSlot);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            newStack = originalStack.copy();
            if (invSlot < this.ironGolemInventory.getContainerSize() ? !this.moveItemStackTo(originalStack, this.ironGolemInventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(originalStack, 0, this.ironGolemInventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }
}

