/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.inventory.maid;

import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.inventory.maid.MaidScreenHandler;
import com.yzqdev.mod.jeanmod.util.GlobalHelper;
import java.text.DecimalFormat;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MaidInventoryScreen
extends AbstractContainerScreen<MaidScreenHandler> {
    private final Maid maid;
    private static final ResourceLocation MAID_SCREEN_TEXTURE = GlobalHelper.id("textures/gui/maid_inv.png");
    private static final ResourceLocation SIDE = ResourceLocation.fromNamespaceAndPath((String)"jean", (String)"textures/gui/maid_gui_side.png");
    public static final ResourceLocation EMPTY_HELD_SLOT_TEXTURE = GlobalHelper.id("item/empty_held_item_slot");
    private static final ResourceLocation CHEST_SLOTS_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/horse/chest_slots");
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private float xMouse;
    private float yMouse;

    public MaidInventoryScreen(MaidScreenHandler menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, menu.maid.getDisplayName());
        this.maid = menu.maid;
    }

    protected void renderBg(GuiGraphics context, float partialTick, int mouseX, int mouseY) {
        int inventoryColumns = 7;
        int centerX = (this.width - this.imageWidth) / 2;
        int centerY = (this.height - this.imageHeight) / 2;
        context.blit(MAID_SCREEN_TEXTURE, centerX - 76, centerY - 54, 0, 0, this.imageWidth + 80, this.imageHeight + 90);
        int inventorySize = this.maid.getInventory().getContainerSize();
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)context, (int)(centerX - 62), (int)(centerY - 73), (int)(centerX - 10), (int)(centerY + 16), (int)35, (float)0.25f, (float)this.xMouse, (float)this.yMouse, (LivingEntity)this.maid);
        this.drawBaseInfoGui(context);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY - 54, 0x404040, false);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.xMouse = mouseX;
        this.yMouse = mouseY;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void drawBaseInfoGui(GuiGraphics graphics) {
        int leftMove = 72;
        int topMove = -30;
        int widthShrink = 0;
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        graphics.blit(SIDE, this.leftPos + 53 - leftMove, this.topPos + 113 + topMove, 0, 0, 9 - widthShrink, 9);
        graphics.blit(SIDE, this.leftPos + 5 - leftMove, this.topPos + 113 + topMove, 0, 9, 47 - widthShrink, 9);
        double hp = this.maid.getHealth() / this.maid.getMaxHealth();
        graphics.blit(SIDE, this.leftPos + 7 - leftMove, this.topPos + 115 + topMove, 2, 18, (int)(43.0 * hp) - widthShrink, 5);
        this.drawNumberScale(graphics, this.maid.getHealth(), this.leftPos + 63 - leftMove, this.topPos + 114 + topMove);
        graphics.blit(SIDE, this.leftPos + 53 - leftMove, this.topPos + 124 + topMove, 9, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5 - leftMove, this.topPos + 124 + topMove, 0, 9, 47, 9);
        double armor = this.maid.getAttributeValue(Attributes.ARMOR) / 20.0;
        graphics.blit(SIDE, this.leftPos + 7 - leftMove, this.topPos + 126 + topMove, 2, 23, (int)(43.0 * armor), 5);
        this.drawNumberScale(graphics, this.maid.getArmorValue(), this.leftPos + 63 - leftMove, this.topPos + 125 + topMove);
        graphics.blit(SIDE, this.leftPos + 53 - leftMove, this.topPos + 135 + topMove, 18, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5 - leftMove, this.topPos + 135 + topMove, 0, 9, 47, 9);
        int exp = this.maid.getExp(this.maid);
        int maidLevel = this.maid.getLevel(this.maid);
        double percent = (double)exp / (double)(100 + 20 * maidLevel);
        graphics.blit(SIDE, this.leftPos + 7 - leftMove, this.topPos + 137 + topMove, 2, 28, (int)(43.0 * percent), 5);
        this.drawNumberScale(graphics, exp, this.leftPos + 63 - leftMove, this.topPos + 136 + topMove);
        graphics.blit(SIDE, this.leftPos + 53 - leftMove, this.topPos + 146 + topMove, 27, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5 - leftMove, this.topPos + 146 + topMove, 0, 9, 47, 9);
        int maidLevel2 = this.maid.getLevel(this.maid);
        double percent2 = (double)maidLevel2 / 50.0;
        graphics.blit(SIDE, this.leftPos + 7 - leftMove, this.topPos + 148 + topMove, 2, 33, (int)(43.0 * percent2), 5);
        this.drawNumberScale(graphics, maidLevel2, this.leftPos + 63 - leftMove, this.topPos + 147 + topMove);
        graphics.blit(SIDE, this.leftPos + 53 - leftMove, this.topPos + 157 + topMove, 36, 0, 9, 9);
        graphics.blit(SIDE, this.leftPos + 5 - leftMove, this.topPos + 157 + topMove, 0, 9, 47, 9);
        double maidDamage = ((MaidScreenHandler)this.menu).attackDamage;
        percent = maidDamage / 30.0;
        graphics.blit(SIDE, this.leftPos + 7 - leftMove, this.topPos + 159 + topMove, 2, 38, (int)(43.0 * percent), 5);
        this.drawNumberScale(graphics, maidDamage, this.leftPos + 63 - leftMove, this.topPos + 156 + topMove);
        graphics.blit(SIDE, this.leftPos + 94, this.topPos + 7 + topMove, 107, 0, 149, 21);
        graphics.blit(SIDE, this.leftPos + 6, this.topPos + 178 + topMove, 0, 47, 67, 25);
    }

    private void drawNumberScale(GuiGraphics graphics, double value, int posX, int posY) {
        String text = DECIMAL_FORMAT.format(value);
        graphics.pose().pushPose();
        graphics.pose().scale(0.5f, 0.5f, 1.0f);
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, text, posX * 2, posY * 2 + 9 / 2, ChatFormatting.DARK_GRAY.getColor().intValue(), false);
        graphics.pose().popPose();
    }
}

