/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.mixin;

import com.yzqdev.mod.jeanmod.Config;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Pig.class})
public class PigsHaveLittersEntity
extends Animal {
    public void spawnChildFromBreeding(ServerLevel world, Animal other) {
        super.spawnChildFromBreeding(world, other);
        for (int i = 0; i < this.getPigletSpawnCount(); ++i) {
            Pig passiveEntity = this.getBreedOffspring(world, (AgeableMob)other);
            if (passiveEntity == null) {
                return;
            }
            passiveEntity.setBaby(true);
            passiveEntity.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
            world.addFreshEntityWithPassengers((Entity)passiveEntity);
        }
    }

    @Shadow
    @Nullable
    public Pig getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return null;
    }

    private int getPigletSpawnCount() {
        String litterSizing = Config.defaultLitterChances;
        String[] confs = litterSizing.split(",");
        int currentSum = 0;
        Random random = new Random();
        float selection = random.nextFloat();
        for (String c : confs) {
            String[] entry = c.split(":");
            if (entry.length != 2) continue;
            int chances = Integer.parseInt(entry[0]);
            int pigletCount = Integer.parseInt(entry[1]) - 1;
            if (selection <= (float)chances / 100.0f + (float)currentSum / 100.0f) {
                return pigletCount;
            }
            currentSum += chances;
        }
        return 0;
    }

    protected PigsHaveLittersEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
    }

    public boolean alwaysAccepts() {
        return super.alwaysAccepts();
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(ItemTags.PIG_FOOD);
    }
}

