/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.mojang.blaze3d.audio.SoundBuffer;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.sound.MaidSoundLoader;
import com.yzqdev.mod.jeanmod.sound.SoundCache;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class MaidSoundInstance
extends AbstractTickableSoundInstance {
    private final String id;
    private final Maid maid;
    private final boolean testSound;
    private final SoundEvent soundEvent;

    public MaidSoundInstance(SoundEvent soundEvent, String id, Maid maid) {
        this(soundEvent, id, maid, false);
    }

    public MaidSoundInstance(SoundEvent soundEvent, String id, Maid maid, boolean testSound) {
        super(soundEvent, SoundSource.NEUTRAL, SoundInstance.createUnseededRandom());
        this.id = id;
        this.maid = maid;
        this.soundEvent = soundEvent;
        this.testSound = testSound;
        this.x = this.maid.getX();
        this.y = this.maid.getY();
        this.z = this.maid.getZ();
    }

    public boolean canPlaySound() {
        return true;
    }

    public void tick() {
        if (!this.maid.isRemoved()) {
            this.x = this.maid.getX();
            this.y = this.maid.getY();
            this.z = this.maid.getZ();
        }
    }

    public String getId() {
        return this.id;
    }

    public Maid getMaid() {
        return this.maid;
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent;
    }

    public boolean isTestSound() {
        return this.testSound;
    }

    @Nullable
    public SoundBuffer getSoundBuffer() {
        SoundCache soundCache = MaidSoundLoader.getSoundCache(this.id);
        if (soundCache != null) {
            return soundCache.getBuffer(this.location);
        }
        return null;
    }
}

