/*
 * Decompiled with CFR 0.152.
 */
package com.yzqdev.mod.jeanmod.sound;

import com.google.common.collect.Maps;
import com.yzqdev.mod.jeanmod.entity.maid.Maid;
import com.yzqdev.mod.jeanmod.sound.ModSoundEvents;
import com.yzqdev.mod.jeanmod.sound.SoundItem;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class SoundUtil {
    public static final Map<String, SoundItem> CACHE = Maps.newLinkedHashMap();
    private static final long MORNING_START = 0L;
    private static final long MORNING_END = 3000L;
    private static final long EVENING_START = 12000L;
    private static final long EVENING_END = 15000L;

    public static SoundEvent environmentSound(Maid maid, SoundEvent fallback, float probability) {
        Level world = maid.level();
        RandomSource rand = maid.getRandom();
        BlockPos pos = maid.blockPosition();
        long dayTime = world.getDayTime();
        Biome biome = (Biome)world.getBiome(pos).value();
        if (rand.nextFloat() < probability && 0L < dayTime && dayTime < 3000L) {
            return (SoundEvent)ModSoundEvents.MAID_MORNING.get();
        }
        if (rand.nextFloat() < probability && 12000L < dayTime && dayTime < 15000L) {
            return (SoundEvent)ModSoundEvents.MAID_NIGHT.get();
        }
        if (rand.nextFloat() < probability && world.isRaining() && SoundUtil.isRainBiome(biome, pos)) {
            return (SoundEvent)ModSoundEvents.MAID_RAIN.get();
        }
        if (rand.nextFloat() < probability && world.isRaining() && SoundUtil.isSnowyBiome(biome, pos)) {
            return (SoundEvent)ModSoundEvents.MAID_SNOW.get();
        }
        if (rand.nextFloat() < probability && biome.coldEnoughToSnow(pos)) {
            return (SoundEvent)ModSoundEvents.MAID_COLD.get();
        }
        if (rand.nextFloat() < probability && SoundUtil.shouldSnowGolemBurn(biome, pos)) {
            return (SoundEvent)ModSoundEvents.MAID_HOT.get();
        }
        return fallback;
    }

    public static SoundEvent attackSound(Maid maid, SoundEvent fallback, float probability) {
        float rand = maid.getRandom().nextFloat();
        if (rand < probability) {
            if (rand > probability / 2.0f) {
                return (SoundEvent)ModSoundEvents.MAID_ATTACK.get();
            }
            return (SoundEvent)ModSoundEvents.MAID_FIND_TARGET.get();
        }
        return fallback;
    }

    public static boolean isRainBiome(Biome biome, BlockPos pos) {
        return biome.getPrecipitationAt(pos) == Biome.Precipitation.RAIN && !SoundUtil.shouldSnowGolemBurn(biome, pos);
    }

    public static boolean isSnowyBiome(Biome biome, BlockPos pos) {
        return biome.getPrecipitationAt(pos) == Biome.Precipitation.SNOW;
    }

    private static boolean shouldSnowGolemBurn(Biome biome, BlockPos pos) {
        return biome.getTemperature(pos) > 1.0f;
    }
}

